function [ h ] = plot_ellipse( x, y, rad_x, rad_y, clr, fill_alpha, res )

if nargin < 5
   clr = [0 0 1];
end

if nargin < 6
   fill_alpha = 1;
end

if nargin < 7
   res = 0.01;
end

theta = 0 : res : 2*pi;
xx = rad_x * cos(theta) + x;
yy = rad_y * sin(theta) + y;

if fill_alpha < 1
   lclr = lighten_colour(clr, 0.5);
   hh = fill(xx, yy, lclr);
   hh.FaceAlpha = fill_alpha;
   hold on;
end

h = plot(xx, yy);
h.Color = clr;

end

