function [ D, P ] = z_comparison (R1, R2, N1, N2)

% Compares correlation matrices R1 and R2, given a sample size of N1; 
% uneven sample sizes can be indicated by defining N2. 
% Convertsthe R values to Z values (Fisher's transform) and 
% compares the difference to the normal distribution.
%
% PARAMETERS:
% 
% R1, R2        - The correlation matrices
% N1            - The sample size
% N2            - The sample size for R2 if different from N1
%
% OUTPUT:
% 
% D             - The difference as a z-score (R1-R2)
% P             - The two-tailed p-values associated with D; this is based 
%                 on the population estimate; for small samples, use a t
%                 test
%
% AUTHOR: Andrew Reid, MNI, 2012
%

% Fisher transform
N_c = size(R1,1);
R1 = get_top(R1);
R2 = get_top(R2);
R1_Z = atanh(R1);
R2_Z = atanh(R2);

if ~exist('N2','var')
   N2=N1; 
end

% Get deltas
D = R1_Z - R2_Z;
D(isnan(D))=0;
V = (sqrt(1/(N1-3) + 1/(N2-3)));
D = D / V;

% Get significance
P = 2 * normcdf(-abs(D));

D = put_bottom_back_on(D,N_c);
P = put_bottom_back_on(P,N_c);
% % Make diagonal ones
% P(isnan(D))=1;