function [ t ] = z2tval ( z, df, inf2max )
% Z2TVAL Converts a set of Z values to zero-centered T values, given df
%   
% z        Vector of Z scores
% df       Degrees of freedom
% inf2max  Optionally, set infinite values to the maximum value
%


if nargin < 3
   inf2max = false; 
end
p = 2*normcdf(-abs(z));
signs=z./abs(z);
t = tinv(p, df);
if inf2max
   t(isinf(t))=max(abs(t(~isinf(t))));
end
t = abs(t).*signs;

end

