function [  ] = write_subject_residuals_to_pajek ( results, subject_header, indexes, alpha_idx, lambda_idx, ...
                                                   output_dir, threshold, split_pos_neg, vertex_vals, varargin)
%UNTITLED2 Write results of @process_subject_residuals
%   

for i = 1 : length(indexes)

    idx = indexes(i);
    x_label = char(subject_header(idx));
    
    results_i = results.(x_label);
    
    filename = [x_label, '_thr_', num2str(int32(threshold * 1000)), '_a_', ...
                num2str(alpha_idx), '_l_', num2str(lambda_idx)];
    filename = fullfile(output_dir, filename);
    betas = results_i.betas(alpha_idx).beta(:,:,lambda_idx);
    
    if threshold > 0
        betas = betas.*threshold_by_sparsity(betas, 1 - threshold);
    end
    
    subject_edge_residuals_glmnet2pajek(results_i.results(alpha_idx), betas, filename, ...
                                        NaN, split_pos_neg, ...
                                        lambda_idx, vertex_vals, varargin{:});
    
end


end

