function [  ] = write_matrix( filename, M, delim, header, format, first_columns )
%WRITE_MATRIX Writes a matrix to file; allows a header to be written also
%   Should be a simple built-in function

R = size(M, 1);
C = size(M, 2);
F = 0;
if exist('first_columns','var')
   F = size(first_columns,2); 
end

fid = fopen(filename, 'w');

%try
    if exist('header','var') && ~isempty(header)
        if C ~= 1
            fprintf(fid,['%s',delim],header{1:end-1});
            fprintf(fid,'%s\n',header{end});
        else
            fprintf(fid,'%s',header{:});
        end
       
    end

    if ~exist('format','var')
        format = '%f';
    end

    f2 = [format '\n'];

    for i = 1 : R
        if F > 0
            for j = 1 : F
                str = first_columns(i,j);
                str=str{:};
                fprintf(fid,'%s%s',str,delim);
            end
        end
       if C == 1
            fprintf(fid,f2,M(i));
       else
            fprintf(fid,[format,delim],M(i,1:end-1));
            fprintf(fid,f2,M(i,end));
       end

    end
% catch err
%    fprintf(err); 
% end

fclose(fid);

end

