function [ coords ] = voxel_to_world( v_coords, hdr )
% voxel_to_world 
%
% Convert voxel to world coordinates, given a NIFTI header in NIAK
% format. Uses the sform transform.

T = zeros(4);
T(1,:) = hdr.details.srow_x;
T(2,:) = hdr.details.srow_y;
T(3,:) = hdr.details.srow_z;
T(4,:) = [0 0 0 1];

pixdim = hdr.details.pixdim;

coords = v_coords * 0;

for i = 1 : size(v_coords,1)
   x = v_coords(i,1); 
   y = v_coords(i,2);
   z = v_coords(i,3);
   
   x = x * T(1,1) + y * T(1,2) + z * T(1,3) + T(1,4);
   y = x * T(2,1) + y * T(2,2) + z * T(2,3) + T(2,4);
   z = x * T(3,1) + y * T(3,2) + z * T(3,3) + T(3,4);
   
   coords(i,:) = [x y z];
   
end


end

