function [ M, idx ] = unique_rnd( A )
%unique_rnd Finds unique elements of A; if multiple entries are found,
%chooses one at random.
%   M - unique elements of A
%   idx - indices of A corresponding to values in M

M = unique(A);
idx = zeros(length(M),1);

for i = 1 : length(M)
   v = M(i);
   F = find(A==v);
   ii = ceil(rand * length(F));
   idx(i) = F(ii);
end


end

