function [ G, M, idx ] = threshold_by_sparsity2( M, sparsity, ge )

%THRESHOLD_BY_SPARSITY Thresholds a vector M such that the
% resulting graph has the given SPARSITY (as a proportion from 0 to 1); or 
% at least a sparsity closest to this value without arbitraily removing
% identical values. For example, if many values are similar around the
% threshold level, none or all of these values are thresholded (determined
% by the 'smaller' argument).
% 
% PARAMETERS:
%   M           An N x 1 vector, 
%   SPARSITY    The desired sparsity, as a proportion from 0 (no edges) to
%               1 (all edges).
%   GE          Whether to use >= to determine values; important if M has
%               many elements of the same value: GE=true retains these
%               values (graph will be less sparse than intended), GE=false
%               removes them (graph will be more sparse than intended).
%
% RETURNS:
%   A binarized graph G where G(i,j)= 1 indicates the existence of an edge 
%   between vertices i and j.
%

if nargin < 3
    ge=true;
end
N = length(M);
K = round(sparsity*N);  

[M_sort, M_ind] = sort(M, 'descend');      % Sort elements

val = M_sort(K);
if val > 0 && ge
    G = M >= val;
else
    G = M > val;
end

M = M.*double(G);
idx = find(G);

end

