function [ z ] = t2zval( t, df, inf2max )
%T2ZVAL Convert T-values to Z-values, given df
%   
% t        T values
% df       Degrees of freedom
% inf2max  Optionally, set infinite values to the maximum value 
%
if nargin < 3
    inf2max=true;
end
signs = t./abs(t);
p = 2*tcdf(-abs(t), df);
z = norminv(p);
if inf2max
   z(isinf(z))=max(abs(z(~isinf(z))));
end
z = abs(z).*signs;

end

