function [ data ] = surfstat_memory_map( M, filename )
%SURFSTAT_MEMORY_MAP Maps a matrix to a file, suitable for use with
% SurfStat.
%   
% PARAMETERS:
%
%   M           N x V matrix, where N is the number of subjects, V is the
%               number of vertices.
%   FILENAME    Path to memory-map file.
%
% RETURNS:
%   DATA        The resulting memory-mapped variable.

V = size (M, 1);
N = size (M, 2);

for i = 1 : N

    if i == 1
        fid=fopen(filename,'wb');
    end
        
    fwrite(fid,M(:,i),'single');

end

fclose(fid);
data = memmapfile(filename,'Format',{'single' [V N] 'Data'},'Writable',true);

