function [  ] = write_vertex_summary_values( values, output_path_prefix, threshold )
%SUBJECT_EDGE_RESIDUAL_GLMNET2VALUES 
%
% Writes vertex-wise values corresponding to the graph produced by 
% @subject_edge_residuals_glmnet2pajek
%
% PARAMETERS:
% 
% values                Betas for optimal index
% output_path_prefix    Path and prefix for output file; suffix and
%                       extension (.net) will be appended to this


glmnet_object = cv_result.glmnet_object;

if nargin < 3
    threshold = NaN;
end

if nargin < 4
    split_pos_neg = true;
end

if nargin < 5 || idx < 1
   lambda =  cv_result.lambda_1se;
   idx=find(glmnet_object.lambda==lambda);
   if numel(idx)==0
      error(['Optimal lambda ', num2str(lambda), ' not found in list..']);
   end
end

if nargin < 6
    vertex_vals = 'none';
end

beta_opt = glmnet_object.beta(:,idx);
if strcmp(vertex_vals, 'max')
    beta_vertex = max(beta_opt,1);
elseif strcmp(vertex_vals, 'sum')
    beta_vertex = sum(beta_opt,1);
elseif strcmp(vertex_vals, 'mean')
    beta_vertex = mean(beta_opt,1);
end

N=sqrt(numel(beta_opt));
beta_opt=reshape(beta_opt,N,N);
if ~isnan(threshold)
    beta_opt=beta_opt.*(abs(beta_opt)>threshold);
end

if ~split_pos_neg
    write_matrix_to_pajek(beta_opt, [output_path_prefix, '.net'], varargin{:});
else
    beta_opt_pos=beta_opt.*double(beta_opt>0);
    write_matrix_to_pajek(beta_opt_pos, [output_path_prefix, '_pos.net'], varargin{:});
    beta_opt_neg=beta_opt.*double(beta_opt<0);
    write_matrix_to_pajek(beta_opt_neg, [output_path_prefix, '_neg.net'], varargin{:});
end

if exist('beta_vertex', 'var')
    val_file = [output_path_prefix, '.txt']
end

end
