function [ h ] = spaghetti_plot ( id, x, y, min_count, group, group_colour, show_legend )

% Displays a spaghetti plot
%
%
%
%
%

if ~exist('min_count','var')
   min_count = 2; 
end

uid = unique(id);
if exist('group_colour','var')
    groups = group_colour(:,1);
    colours = group_colour(:,2);
end

%h = figure;


if ~exist('group','var')
   h = plot_group(id, uid, x, y, 'b', min_count);
   hold off;
   return;
end

lh=zeros(length(groups),1);
ugrp = get_ugroups(group, id);

for i = 1 : length(groups)
    ugrp_i = strcmp(ugrp, groups(i));
    lh(i) = plot_group(id, uid(ugrp_i), x, y, cell2mat(colours(i)), min_count);
end

h = lh(1);

hold off;

if exist('show_legend','var') && show_legend
   legend(lh,groups); 
end

end

function [ h ] = plot_group( id, uid, x, y, clr, min_count )

    started = false;
    for i = 1 : length(uid)
        id_i = uid(i);
        T = strcmp(id, id_i);
        x_i = x(T);
        if length(x_i) >= min_count
            [x_i, idx] = sort(x_i);
            y_i = y(T);
            y_i = y_i(idx);

            h_i = line(x_i, y_i);
            set(h_i, 'Color', clr);

            if ~started
               h = h_i;
               hold on; 
               started = true;
            end
        end
    end

end

function [ ugrp ] = get_ugroups(group, id)

    uid = unique(id);
    ugrp=cell(length(uid),1);
    
    for i = 1 : length(uid)
       id_i = uid(i);
       idx = find(strcmp(id, id_i),1);
       ugrp(i) = group(idx);
    end

end

function [ h ] = plot_group2( grp, id, uid, x, y, clr, min_count )

    started = false;
    for i = 1 : length(uid)

        id_i = uid(i);
        idx_f = find(id, id_i, 'first');
        grp_i = grp
        
        T = strcmp(id, id_i);
        x_i = x(T);
        if length(x_i) >= min_count
            [x_i, idx] = sort(x_i);
            y_i = y(T);
            y_i = y_i(idx);

            h_i = line(x_i, y_i);
            set(h_i, 'Color', clr);

            if ~started
               h = h_i;
               hold on; 
               started = true;
            end
        end
    end

end