function [ sm_polyline ] = smooth_polyline_ma( polyline, n_sm )
% smooth_polyline_ma 
%
% Smooths polyline with a moving average, of size n_sm; s_nm should be an
% odd number; otherwise it will be treated as n_sm+1
%

sm_polyline = polyline;
win=ceil((n_sm-1)/2);
n = size (polyline,1);

for i = 1 : n
    i0 = max(1,i-win);
    i1 = min(i+win,n);
    
    sub = polyline(i0:i1,:);
    p = mean(sub,1);
    sm_polyline(i,:) = p;
end


end

