% Sandbox:      Loading subject data & thickness
%               Defining a GLM
%               Fitting a GLM with SurfStat
%               Obtaining residuals

% Load subject data
[subject_data]=csvimport('/export02/data/adni/metadata/subject_group_age_sex_volume_15t.txt', 'noHeader', true);
volume=cell2mat(subject_data(:,8));
rid=cell2mat(subject_data(:,3));
age=cell2mat(subject_data(:,2));
sex=subject_data(:,5);

% Convert to model terms
Vol=term(volume);
Sex=term(sex);
Age=term(age);
Rid=term(var2fac(rid));

% Define the model
M=1+Age+Sex+Age*Sex+random(Rid)+I;

% Load cortical thickness
[thick_left thick_right]=textread('/export02/data/matlab/Andrew_matlab/adni_results_1665_15t/thickness_files_1665.txt','%s %s','delimiter',',');
Y=SurfStatReadData([thick_left, thick_right]);

