function [  ] = set_moab_file( path, n_nodes, ppn, wall_time, queue )
%SET_MOAB_FILE Writes/overwrites moab.m file for setting the 
%              number of nodes/processors per node for remote parallel
%              processing.
%
% Note: for Guillimin, this moab.m file must be located in the same
% directory as the script or function passed to the batch command. See
% https://support.clumeq.ca/index.php/guillimin-getting-started/guillimin-matlab
%

file = fullfile(path, 'moab.m');
fid = fopen(file, 'w');

if nargin < 5
    if ppn < 12
       queue = 'sw';
    else
       queue = 'lm'; 
    end
end

fprintf(fid, 'classdef moab\n\tproperties\n');
fprintf(fid, '\t\t%% Generated by set_moab_file.m\n');
fprintf(fid, '\t\tnumberOfNodes = %i\n\t\tprocsPerNode = %i\n\t\tWallTime = ''%s''\n\t\tqueue = ''%s''\n', ...
                n_nodes, ppn, wall_time, queue);
fprintf(fid, '\tend\nend\n');
fclose(fid);

end

