function [ labels ] = rois_to_vertices( roi_labels, rois, values )
%ROIS_TO_VERTICES Convert ROI values to vertex-wise values
%   
% PARAMETERS:
% 
% roi_labels:       N x 1 vertex-ROI assignments
% rois:             R x 1 list of ROI indices
% values:           R x 1 list of ROI-associated values
%
% RETURNS:
%
% labels:           N x 1 vertex-wise values
%
% Author: Andrew Reid, MNI, 2012

R = length(rois);
N = length(roi_labels);
labels = zeros(N,1);

for i = 1 : R
   roi = rois(i);
   idx = find(roi_labels == roi);
   labels(idx) = values(i);
end

end

