function [ X ] = remove_outliers( X, alpha, row_wise )
% Removes outliers, outside alpha, by setting them to NaN in X. If row_wise
% is true, removes outliers row-wise

if nargin < 3
    row_wise = false;
end

if ~row_wise
   X = deleteoutliers(X,alpha,true); 
   return;
end

for i = 1 : size(X,2)
   x = X(:,i);
   x = deleteoutliers(x,alpha,true);
   X(:,i) = x;
end

end

