function [ V_new ] = reindex_volume( V, idx_old, idx_new, no_val )
%REINDEX_VOLUME Reindexes an integer volume (e.g., parcellation), replacing
%               old indices with new ones.
%   
% volume      - volume data matrix
% idx_old     - old indices
% idx_new     - new indices (length must equal idx_old)
% no_val      - value to set for no match, default = NaN

if nargin < 4
   no_val = NaN; 
end

V_new = ones(size(V)) * no_val;

for i = 1 : length(idx_new)
   
    V_new(V==idx_old(i)) = idx_new(i);
    
end

end

