function [ data, instances ] = read_surface_data( source_dir, subjects, subdir, pattern )
%READ_SURFACE_DATA Read vertex-wise data from a subject directory.
%   
% Searches all subject subfolders in a source directory, matching the "subjects" list.
% In each folder, reads each file matching "pattern" and appends it to the output matrix,
% data. The instances variable is comprised of subject/visit entries of the form
% "subject_visit".
%
% data is an N x M array, where N is # of unique subject/visit, and M is # vertices

N_subj = 0;
N_visits = 0;
clear subject_data subjects_ok;

% How many unique subject/visits?
for s = 1 : numel(subjects)
   subject = subjects{s};
   
   files = dir(fullfile(source_dir, subject, subdir, [subject '_' pattern]));
   
   if numel(files) == 0
       fprintf('No data found for subject %s.\n', subject); 
   else
       subject_data.(['S_' subject]).visits = {files.name};
       N_subj = N_subj + 1;
       subjects_ok(N_subj) = {subject};
       N_visits = N_visits + numel({files.name});
   end
end

% Read data
if N_subj == 0
   fprintf('ERROR: No data found in %s!\n', source_dir); 
   data = [];
   instances = [];
   return;
end

% How many vertices?
subjects = subjects_ok;
file_name = fullfile(source_dir, subjects{1}, subdir, subject_data.(['S_' subjects{1}]).visits{1});
fid=fopen(file_name);
D = textscan(fid, '%f');
fclose(fid);
D = D{1};
N_vert = numel(D);

data = zeros(N_visits,N_vert);
instances = cell(N_visits,1);
i = 1;

for s = 1 : N_subj
   subject = subjects{s};
   visits = subject_data.(['S_' subject]).visits;
   for v = 1 : numel(visits)
       visit = visits{v};
       file_name = fullfile(source_dir, subject, subdir, visit);
       fid=fopen(file_name);
       D = textscan(fid, '%f');
       fclose(fid);
       data(i,:) = D{1};
       visit = strsplit(visit,'_');
       visit = strsplit(visit{numel(visit)},'.');
       instances(i) = {[subject '_' visit{1}]};
       i = i + 1;
   end
   
end

end

