function [ cmap ] = read_mgui_cmap_asc( file, n_items )
% Reads a discrete colour map in ModelGUI XML format

cmap_in = csvimport(file, 'noHeader', true);
cmap = cell2mat(cmap_in(:,2:4));

if nargin < 2 || n_items < size(cmap,1)
    return;
end

% Interpolate values

x = cell2mat(cmap_in(:,1));
min_x = min(x);
max_x = max(x);
dd = (max_x-min_x) / (n_items-1);
xx = min_x : dd : max_x;
cmap2 = zeros(n_items,3);

for i = 1 : 3
    cmap2(:,i) = linterp(x,cmap(:,i),xx');
end

cmap=cmap2;