function [ cmap, idx ] = read_mgui_cmap( file )
% Reads a discrete colour map in ModelGUI XML format

fid = fopen(file);

tline = fgets(fid);
N = 0;
while ischar(tline)
    tline = fgets(fid);
    if length(tline) > 6
        if strcmp(tline(2:6),'<Item')
            N = N + 1;
        end
    end
end
fclose(fid);
fid = fopen(file);

i = 1;
idx = nan(N,1);
cmap = nan(N,3);
tline = fgets(fid);
while ischar(tline)
    if length(tline) > 10
        if strcmp(tline(2:6),'<Item')
           % start of item 
           idx1 = findstr(tline,'''');
           if length(idx1) > 1
              j = tline(idx1(1)+1:idx1(2)-1);
              idx(i) = str2num(j);
           end
        elseif strcmp(tline(3:11),'<Colour4f') || strcmp(tline(3:11),'<Colour3f')
           % start of colour
           r = str2double(tline(20:22));
           g = str2double(tline(34:36));
           b = str2double(tline(47:49));
           cmap(i,:) = [r g b];
           i = i + 1;
        end
    end
    tline = fgets(fid);
end

fclose(fid);

end

