function [ Y, subjects ] = read_fdgpet_data( source_dir, subdir, prefix, pattern, subjects )
%READ_CIVET_DATA 
%
% Reads vertex-wise FDG PET data 
%

%
% AUTHOR Andrew Reid, MNI, 2012

subject_list = dir(source_dir);
if nargin < 5
    isdir = [subject_list.isdir];
    subjects = {subject_list.name};
    subjects = subjects(isdir);
    subjects = subjects(3:end);
end

if ~isempty(prefix)
   if ~strcmp(prefix(length(prefix)),'_')
      prefix = [prefix '_']; 
   end
end

j = 1;
subs=cell(0);
% Filter subject list
for i = 3 : numel(subject_list)
   
    this_subject = subject_list(i);
    
    if (this_subject.isdir)
        if nargin < 5
           subs(j) = {this_subject.name};
           j = j + 1;
        else
           test = strcmp(this_subject.name,subjects);
           if sum(test)>0
               subs(j) = {this_subject.name};
               j = j + 1;
           end
        end
    end
    
end

if numel(subs) == 0
   error('No subjects found!'); 
end

clear subject_files; clear subjects;
to_keep=true(numel(subs),1);
j=1;
for i = 1 : numel(subs)
    
    subject = subs(i);
    subj_str=char(subject);
    
    name = [prefix, subj_str, '_', pattern, '*.txt'];
    path = fullfile(source_dir, subj_str, subdir);
    fils = dir(fullfile(path,name));
    if numel(fils) == 0
        to_keep(i) = false;
    else
        for k = 1 : numel(fils)
            subject_files(j,1) = {fullfile(path,fils(k).name)};
            subjects(j,1) = subject;
            j = j + 1;
        end
    end
end

% s = sum(~to_keep);
% rejected = [];
% if s > 0
%    subjects = subjects(to_keep);
%    rejected = subjects(~to_keep);
% end

% Read data
Y = SurfStatReadData(subject_files);

end

