function [ A, labels] = read_cocomac_matrix ( filename )

%read_cocomac_matrix Read in the output of a CoCoMac result
%
% INPUT:
% filename  Name of the Matlab-friendly CSV file obtained from the CoCoMac
%           website
%
% OUTPUT:
%
% A         The weighted connectivity matrix 
% labels    Row/column labels
%

fid = fopen(filename);

tline = fgetl(fid);
while (ischar(tline) && strncmpi(tline,'% colLabels',11)==0)
    tline = fgetl(fid);
end

if ~ischar(tline)
   error('Unexpected end of file!'); 
end

tline = strrep(tline,'"','');
tline = tline(14:end-1);
labels = strsplit(tline,',');

A = zeros(length(labels));

fgetl(fid);   % Skip the next line
tline = fgetl(fid);
i = 1;
while (ischar(tline))
    C = strsplit(tline,',');
    A(:,i) = str2double(C);
    tline = fgetl(fid);
    i = i + 1;
end

end