function [ results ] = process_subject_residuals ( subject_data, subject_header, indexes, subjects_all, groups_all, y_all, params, normal_grp )
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

if ~exist('normal_grp','var')
    normal_grp = 'Normal';
end

if ~exist('params','var')
    params = analyze_adni_binary_params;
end

params.verbose=false;

for i = 1 : length(indexes)
    idx = indexes(i);
    x_name=char(subject_header(idx));
    
    fprintf('%s',['Processing variable "', x_name, '"..']);
    
    if iscell(subject_data)
        x_scores=cell2mat(subject_data(:,idx));
    else
        x_scores=subject_data(:,idx);
    end
    x_scores_pos=x_scores(x_scores>-1);
    subjects_x=subjects_all(x_scores>-1);
    groups_x=filter_values_by_subject(groups_all',subjects_all,subjects_x)';
    is_nc_x=strcmp(groups_x,normal_grp);
    y_values=filter_values_by_subject(y_all',subjects_all,subjects_x)';
    [results.(x_name).results, results.(x_name).resids, results.(x_name).betas] = analyze_subject_edge_residuals_glmnet(y_values', x_scores_pos, is_nc_x, params);
    results.(x_name).scores_pos=x_scores_pos;
    
    fprintf('%s\n','..done.');
end

end



