function [ h ] = plots_glmfit( y, glmnet_predict, opt_idx, options )

%
% Plots actual (y) versus predicted values (x via glmnetPredict) at opt_idx
%
% PARAMETERS:
%
% cv_glmnet_fit            The output of cvglmnet

if nargin < 4
  options = plots_glmfit_options;
  options.xlim = [0 max(y)];
  options.ylim = [0 max(y)];
end

h = figure;
predict_opt=glmnet_predict(:,opt_idx);
scatter(y,predict_opt);
xlim(options.xlim);
ylim(options.ylim);
xlabel(options.xlabel);
ylabel(options.ylabel);
title(['Prediction accuracy: ', options.title]);

if options.hasline == true
    hold on;
    line(options.xlim, options.ylim, 'Color', options.colour, 'LineStyle', options.linestyle);
end