function [ stats ] = plots_corr_net_binary2( results, group_list, params );

% Plots the results of analyze_adni_binary, plotting lines and boxplots
% together for each of (1.) global/local efficiency; and (2.) global/local
% cost efficiency.

if ~exist('params','var')
   params = plots_corr_net_binary_params;
end

if ~isfield(params,'colours') || isempty(params.colours)
   params.colours = ['r' 'g' 'b' 'c' 'm' 'k'];
end

if ~isfield(params,'interval') || isempty(params.interval)
   params.interval = 1:length(results.thresholds);
end

%% Global/Local Efficiency

 % 1. Boxplots of integrals
    boot_n = size(results.(cell2mat(group_list(1))).global_E,2);
    group_n = length(group_list);
    integral_global = zeros(group_n, boot_n);
    integral_local = zeros(group_n, boot_n);
%     max_global_costE = zeros(group_n, boot_n);
%     max_local_costE = zeros(group_n, boot_n);
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        integral_global(g,:) = results.(group).integral_global;
        integral_local(g,:) = results.(group).integral_local;
%         max_global_costE(g,:) = results.(group).max_global_costE;
%         max_local_costE(g,:) = results.(group).max_local_costE;
    end
    figure;
    set(gcf,'Color','w');
    if isfield(params,'window_size') && ~isempty(params.window_size);
       p = get(gcf,'Position');
       p(1)=100;
       p(2)=100;
       p(3)=params.window_size(1);
       p(4)=params.window_size(2);
       set(gcf,'Position',p) 
    end
        
    subplot(2,2,3);
    h = boxplot(integral_global', 'labels', group_list);
    title('Integrated Global Efficiency', 'FontWeight', 'bold', 'FontSize', 14);
    
    subplot(2,2,4);
    h = boxplot(integral_local', 'labels', group_list);
    title('Integrated Local Efficiency', 'FontWeight', 'bold', 'FontSize', 14);
    
% 2. Line plots of mean & std efficiency vs. sparsity
    
    subplot (2,2,1);

    % Global efficiency
    min_y=2;
    max_y=-1;
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        %if g <= length(colours)
           colour = params.colours(g);
           thresholds = results.thresholds(params.interval);
           global_e_mean = results.(group).mean.global_E(params.interval,:);
           global_e_std = results.(group).std.global_E(params.interval,:);
           min_y=min(min(global_e_mean),min_y);
           max_y=max(max(global_e_mean),max_y);
           
        if g == 1
           if isfield(params,'show_error') && params.show_error
               errorbar(thresholds, global_e_mean, global_e_std, 'Color', colour);
           else
               line(thresholds, global_e_mean, 'Color', colour);
           end
           title('Global Efficiency', 'FontWeight', 'bold', 'FontSize', 14);
           if exist('x_label','var'), xlabel(x_label); end
           xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
           ylim([max(min(global_e_mean)-0.1,0) min(max(global_e_mean)+0.1,1)]);
           hold on; 
        else
           if isfield(params,'show_error') && params.show_error
                errorbar(thresholds, global_e_mean, global_e_std, 'Color', colour);
           else
               line(thresholds, global_e_mean, 'Color', colour);
           end
        end
    end
    
    ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
    legend(group_list);
    hold off;

    % Local efficiency
    min_y=2;
    max_y=-1;
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        %if g <= length(colours)
           colour = params.colours(g);

           thresholds = results.thresholds(params.interval);
           local_e_mean = results.(group).mean.local_E(params.interval,:);
           local_e_std = results.(group).std.local_E(params.interval,:);
           min_y=min(min(local_e_mean),min_y);
           max_y=max(max(local_e_mean),max_y);
           
        if g == 1
           %figure;
           subplot(2,2,2);
           if isfield(params,'show_error') && params.show_error
               errorbar(thresholds, local_e_mean, local_e_std, 'Color', colour);
           else
               line(thresholds, local_e_mean, 'Color', colour);
           end
           title('Local Efficiency', 'FontWeight', 'bold', 'FontSize', 14);
           if exist('x_label','var'), xlabel(x_label); end
           xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
           %ylim([max(min(local_e_mean)-0.1,0) min(max(local_e_mean)+0.1,1)]);
           
           hold on; 
        else
           if isfield(params,'show_error') && params.show_error
                errorbar(thresholds, local_e_mean, local_e_std, 'Color', colour);
           else
               line(thresholds, local_e_mean, 'Color', colour);
           end
        end
    end
    
    ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
    legend(group_list);
    hold off;
    
    
    %% Cost Efficiency
    
    % Boxplots
    boot_n = size(results.(cell2mat(group_list(1))).global_E,2);
    group_n = length(group_list);
%     integral_global = zeros(group_n, boot_n);
%     integral_local = zeros(group_n, boot_n);
    max_global_costE = zeros(group_n, boot_n);
    max_local_costE = zeros(group_n, boot_n);
    for g = 1 : group_n
        group = cell2mat(group_list(g));
%         integral_global(g,:) = results.(group).integral_global;
%         integral_local(g,:) = results.(group).integral_local;
        max_global_costE(g,:) = results.(group).max_global_costE;
        max_local_costE(g,:) = results.(group).max_local_costE;
    end
    figure;
    set(gcf,'Color','w');
    if isfield(params,'window_size') && ~isempty(params.window_size);
       p = get(gcf,'Position');
       p(1)=100;
       p(2)=100;
       p(3)=params.window_size(1);
       p(4)=params.window_size(2);
       set(gcf,'Position',p) 
    end
    
    subplot(2,2,3);
    h = boxplot(max_global_costE', 'labels', group_list);
    title('Maximal Global Cost Efficiency', 'FontWeight', 'bold', 'FontSize', 14);
    %ylim([0 1]);
    
    %figure;
    subplot(2,2,4);
    h = boxplot(max_local_costE', 'labels', group_list);
    title('Maximal Local Cost Efficiency', 'FontWeight', 'bold', 'FontSize', 14);
    
    % Line Plots
    
    % Global cost efficiency
    min_y=2;
    max_y=-1;
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        %if g <= length(colours)
           colour = params.colours(g);
           
           thresholds = results.thresholds(params.interval);
           % Get pearson value at each threshold
           %pearson = min(results.(group).min_pearson,[],2)';
           global_ecost_mean = results.(group).mean.global_costE(params.interval,:);
           global_ecost_std = results.(group).std.global_costE(params.interval,:);
           min_y=min(min(global_ecost_mean),min_y);
           max_y=max(max(global_ecost_mean),max_y);
           
        if g == 1
           %figure;
           subplot(2,2,1);
           %plot(results.sparsities, results.(group).mean.global_E, colour);
           if isfield(params,'show_error') && params.show_error
               errorbar(thresholds, global_ecost_mean, global_ecost_std, 'Color', colour);
           else
               line(thresholds, global_ecost_mean, 'Color', colour);
           end
           title('Global Cost Efficiency', 'FontWeight', 'bold', 'FontSize', 14);
           if isfield(params,'x_label'), xlabel(params.x_label); end
           xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
           %ylim([max(min(global_ecost_mean)-0.1,0) min(max(global_ecost_mean)+0.1,1)]);
           
           hold on; 
        else
           if isfield(params,'show_error') && params.show_error
                errorbar(thresholds, global_ecost_mean, global_ecost_std, 'Color', colour);
           else
               line(thresholds, global_ecost_mean, 'Color', colour);
           end
            
        end
    end
    
    ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
    legend(group_list);
    hold off;
    
    % Local cost efficiency
    min_y=2;
    max_y=-1;
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        %if g <= length(colours)
           colour = params.colours(g);

           thresholds = results.thresholds(params.interval);
           %pearson = min(results.(group).min_pearson,[],2)';
           local_ecost_mean = results.(group).mean.local_costE(params.interval,:);
           local_ecost_std = results.(group).std.local_costE(params.interval,:);
           min_y=min(min(local_ecost_mean),min_y);
           max_y=max(max(local_ecost_mean),max_y);
           
        if g == 1
           %figure;
           subplot(2,2,2);
           
           if isfield(params,'show_error') && params.show_error
               errorbar(thresholds, local_ecost_mean, local_ecost_std, 'Color', colour);
           else
               line(thresholds, local_ecost_mean, 'Color', colour);
           end
           title('Local Cost Efficiency', 'FontWeight', 'bold', 'FontSize', 14);
           if isfield(params,'x_label'), xlabel(params.x_label); end
           xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
           %ylim([max(min(local_ecost_mean)-0.1,0) min(max(local_ecost_mean)+0.1,1)]);
           
           hold on; 
        else
           if isfield(params,'show_error') && params.show_error
               errorbar(thresholds, local_ecost_mean, local_ecost_std, 'Color', colour);
           else
               line(thresholds, local_ecost_mean, 'Color', colour);
           end
        end
    end
    
    ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
    legend(group_list);
    hold off;
    
    
    
    %% Centrality

%  % 1. Boxplots of integrals
%     boot_n = size(results.(cell2mat(group_list(1))).global_E,2);
%     group_n = length(group_list);
%     integral_deg_centr = zeros(group_n, boot_n);
%     integral_betw_centr = zeros(group_n, boot_n);
%     for g = 1 : group_n
%         group = cell2mat(group_list(g));
%         integral_deg_centr(g,:) = results.(group).integral_deg_centr;
%         integral_betw_centr(g,:) = results.(group).integral_betw_centr;
%     end
%     figure;
%     set(gcf,'Color','w');
%     if isfield(params,'window_size') && ~isempty(params.window_size);
%        p = get(gcf,'Position');
%        p(1)=100;
%        p(2)=100;
%        p(3)=params.window_size(1);
%        p(4)=params.window_size(2);
%        set(gcf,'Position',p) 
%     end
%         
%     subplot(2,2,3);
%     h = boxplot(integral_deg_centr', 'labels', group_list);
%     title('Integrated Degree Centrality', 'FontWeight', 'bold', 'FontSize', 14);
%     
%     subplot(2,2,4);
%     h = boxplot(integral_betw_centr', 'labels', group_list);
%     title('Integrated Betweenness Centrality', 'FontWeight', 'bold', 'FontSize', 14);
%     
% % 2. Line plots of mean & std efficiency vs. sparsity
%     
%     subplot (2,2,1);
% 
%     % Degree centrality
%     min_y=2;
%     max_y=-1;
%     for g = 1 : group_n
%         group = cell2mat(group_list(g));
%         %if g <= length(colours)
%            colour = params.colours(g);
%            thresholds = results.thresholds(params.interval);
%            deg_centr_mean = results.(group).mean.deg_centr(params.interval,:);
%            deg_centr_std = results.(group).std.deg_centr(params.interval,:);
%            min_y=min(min(deg_centr_mean),min_y);
%            max_y=max(max(deg_centr_mean),max_y);
%            
%         if g == 1
%            if isfield(params,'show_error') && params.show_error
%                errorbar(thresholds, deg_centr_mean, deg_centr_std, 'Color', colour);
%            else
%                line(thresholds, global_e_mean, 'Color', colour);
%            end
%            title('Degree Centrality', 'FontWeight', 'bold', 'FontSize', 14);
%            if exist('x_label','var'), xlabel(x_label); end
%            xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
% %            ylim([max(min(deg_centr_mean)-0.1,0) min(max(deg_centr_mean)+0.1,1)]);
%            hold on; 
%         else
%            if isfield(params,'show_error') && params.show_error
%                 errorbar(thresholds, deg_centr_mean, deg_centr_std, 'Color', colour);
%            else
%                line(thresholds, deg_centr_mean, 'Color', colour);
%            end
%         end
%     end
%     
%     ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
%     legend(group_list);
%     hold off;
% 
%     % Betweenness centrality
%     min_y=2;
%     max_y=-1;
%     for g = 1 : group_n
%         group = cell2mat(group_list(g));
%         %if g <= length(colours)
%            colour = params.colours(g);
% 
%            thresholds = results.thresholds(params.interval);
%            betw_centr_mean = results.(group).mean.betw_centr(params.interval,:);
%            betw_centr_std = results.(group).std.betw_centr(params.interval,:);
%            min_y=min(min(local_e_mean),min_y);
%            max_y=max(max(local_e_mean),max_y);
%            
%         if g == 1
%            %figure;
%            subplot(2,2,2);
%            if isfield(params,'show_error') && params.show_error
%                errorbar(thresholds, betw_centr_mean, betw_centr_std, 'Color', colour);
%            else
%                line(thresholds, betw_centr_mean, 'Color', colour);
%            end
%            title('Betweenness Centrality', 'FontWeight', 'bold', 'FontSize', 14);
%            if exist('x_label','var'), xlabel(x_label); end
%            xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
%            
%            hold on; 
%         else
%            if isfield(params,'show_error') && params.show_error
%                 errorbar(thresholds, betw_centr_mean, betw_centr_std, 'Color', colour);
%            else
%                line(thresholds, betw_centr_mean, 'Color', colour);
%            end
%         end
%     end
%     
%     ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
%     legend(group_list);
%     hold off;
    
    