function [ stats ] = plots_corr_net_binary( results, group_list, x_label, colours, interval );

% Plots the results of analyze_adni_binary

if ~exist('colours','var') || isempty(colours)
   colours = ['r' 'g' 'b' 'c' 'm' 'k'];
end

if ~exist('interval','var')
   interval = 1:length(results.thresholds);
end

 % 1. Boxplots of integrals & cost efficiency
    boot_n = size(results.(cell2mat(group_list(1))).global_E,2);
    group_n = length(group_list);
    integral_global = zeros(group_n, boot_n);
    integral_local = zeros(group_n, boot_n);
    max_global_costE = zeros(group_n, boot_n);
    max_local_costE = zeros(group_n, boot_n);
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        integral_global(g,:) = results.(group).integral_global;
        integral_local(g,:) = results.(group).integral_local;
        max_global_costE(g,:) = results.(group).max_global_costE;
        max_local_costE(g,:) = results.(group).max_local_costE;
    end
    figure;
    set(gcf,'Color','w');
    subplot(2,2,1);
    h = boxplot(integral_global', 'labels', group_list);
    title('Integrated Global Efficiency', 'FontWeight', 'bold');
    %ylim([0 1]);
    
    %figure;
    subplot(2,2,2);
    h = boxplot(integral_local', 'labels', group_list);
    title('Integrated Local Efficiency', 'FontWeight', 'bold');
    %ylim([0 1]);
    
    %figure;
    subplot(2,2,3);
    h = boxplot(max_global_costE', 'labels', group_list);
    title('Maximal Global Cost Efficiency', 'FontWeight', 'bold');
    %ylim([0 1]);
    
    %figure;
    subplot(2,2,4);
    h = boxplot(max_local_costE', 'labels', group_list);
    title('Maximal Local Cost Efficiency', 'FontWeight', 'bold');
    %ylim([0 1]);
    
% 2. Line plots of mean & std efficiency + cost efficiency vs. sparsity
    
    figure;
    set(gcf,'Color','w');
    subplot (2,2,1);

    % Global efficiency
    min_y=2;
    max_y=-1;
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        %if g <= length(colours)
           colour = colours(g);
           thresholds = results.thresholds(interval);
           global_e_mean = results.(group).mean.global_E(interval,:);
           global_e_std = results.(group).std.global_E(interval,:);
           min_y=min(min(global_e_mean),min_y);
           max_y=max(max(global_e_mean),max_y);
           
        if g == 1
           %figure;
           errorbar(thresholds, global_e_mean, global_e_std, 'Color', colour);
           title('Global Efficiency', 'FontWeight', 'bold');
           if exist('x_label','var'), xlabel(x_label); end
            xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
           ylim([max(min(global_e_mean)-0.1,0) min(max(global_e_mean)+0.1,1)]);
           hold on; 
        else
           errorbar(thresholds, global_e_mean, global_e_std, 'Color', colour);
        end
    end
    
    ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
    legend(group_list);
    hold off;

    % Local efficiency
    min_y=2;
    max_y=-1;
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        %if g <= length(colours)
           colour = colours(g);

           thresholds = results.thresholds(interval);
           local_e_mean = results.(group).mean.local_E(interval,:);
           local_e_std = results.(group).std.local_E(interval,:);
           min_y=min(min(local_e_mean),min_y);
           max_y=max(max(local_e_mean),max_y);
           
        if g == 1
           %figure;
           subplot(2,2,2);
           %plot(results.sparsities, results.(group).mean.local_E, colour);
           errorbar(thresholds, local_e_mean, local_e_std, 'Color', colour);
           title('Local Efficiency', 'FontWeight', 'bold');
           if exist('x_label','var'), xlabel(x_label); end
           xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
           %ylim([max(min(local_e_mean)-0.1,0) min(max(local_e_mean)+0.1,1)]);
           
           hold on; 
        else
           %plot(results.sparsities, results.(group).mean.local_E, colour);
           errorbar(thresholds, local_e_mean, local_e_std, 'Color', colour);
        end
    end
    
    ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
    legend(group_list);
    hold off;
    
    % Global cost efficiency
    min_y=2;
    max_y=-1;
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        %if g <= length(colours)
           colour = colours(g);
           
           thresholds = results.thresholds(interval);
           % Get pearson value at each threshold
           %pearson = min(results.(group).min_pearson,[],2)';
           global_ecost_mean = results.(group).mean.global_costE(interval,:);
           global_ecost_std = results.(group).std.global_costE(interval,:);
           min_y=min(min(global_ecost_mean),min_y);
           max_y=max(max(global_ecost_mean),max_y);
           
        if g == 1
           %figure;
           subplot(2,2,3);
           %plot(results.sparsities, results.(group).mean.global_E, colour);
           errorbar(thresholds, global_ecost_mean, global_ecost_std, 'Color', colour);
           title('Global Cost Efficiency', 'FontWeight', 'bold');
           if exist('x_label','var'), xlabel(x_label); end
           xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
           %ylim([max(min(global_ecost_mean)-0.1,0) min(max(global_ecost_mean)+0.1,1)]);
           
           hold on; 
        else
           %plot(results.sparsities, results.(group).mean.global_E, colour);
           errorbar(thresholds, global_ecost_mean, global_ecost_std, 'Color', colour);
        end
    end
    
    ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
    legend(group_list);
    hold off;
    
    % Local cost efficiency
    min_y=2;
    max_y=-1;
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        %if g <= length(colours)
           colour = colours(g);

           thresholds = results.thresholds(interval);
           %pearson = min(results.(group).min_pearson,[],2)';
           local_ecost_mean = results.(group).mean.local_costE(interval,:);
           local_ecost_std = results.(group).std.local_costE(interval,:);
           min_y=min(min(local_ecost_mean),min_y);
           max_y=max(max(local_ecost_mean),max_y);
           
        if g == 1
           %figure;
           subplot(2,2,4);
           %plot(results.sparsities, results.(group).mean.local_E, colour);
           errorbar(thresholds, local_ecost_mean, local_ecost_std, 'Color', colour);
           title('Local Cost Efficiency', 'FontWeight', 'bold');
           if exist('x_label','var'), xlabel(x_label); end
           xlim([max(min(thresholds)-0.05,0) min(max(thresholds)+0.05,1)]);
           %ylim([max(min(local_ecost_mean)-0.1,0) min(max(local_ecost_mean)+0.1,1)]);
           
           hold on; 
        else
           %plot(results.sparsities, results.(group).mean.local_E, colour);
           errorbar(thresholds, local_ecost_mean, local_ecost_std, 'Color', colour);
        end
    end
    
    ylim([max(min_y-0.1,0) min(max_y+0.1,1)]);
    legend(group_list);
    hold off;
    
    