function plots_adni_weighted( results, group_list, colours );

% Plots the results of analyze_adni_weighted

if nargin < 3
   colours = ['r' 'g' 'b' 'c' 'm' 'y']; 
end

 % 1. Boxplots of efficiency scores
    boot_n = length(results.(cell2mat(group_list(1))).e_global);
    group_n = length(group_list);
    e_global = zeros(group_n, boot_n);
    e_local = zeros(group_n, boot_n);
    for g = 1 : group_n
        group = cell2mat(group_list(g));
        e_global(g,:) = results.(group).e_global;
        e_local(g,:) = results.(group).e_local;
    end
    figure;
    h = boxplot(e_global', 'labels', group_list);
    title('Global Efficiency (weighted)', 'FontWeight', 'bold');
    
    figure;
    h = boxplot(e_local', 'labels', group_list);
    title('Local Efficiency (weighted)', 'FontWeight', 'bold');
    