function [  ] = plot_subject_residuals( results, subject_header, indexes, alpha_idx, lambda_idx, plot_options )
%plot_subject_residuals Plot the results of @process_subject_residuals
%                       for a particular set of x variables
%   Produces scatter, error, and beta plots, depending on plot_options;
%   see @plot_subject_edge_residuals_glmnet
%

if nargin < 6
   plot_options = plot_subject_edge_residuals_glmnet_options; 
end

for i = 1 : length(indexes)

    idx = indexes(i);
    x_label = char(subject_header(idx));
    
    plot_options.xlabel=[x_label ' (actual)']; 
    plot_options.ylabel=[x_label ' (predicted)']; 
    plot_options.title=x_label;
    
    results_i = results.(x_label);

    plot_subject_edge_residuals_glmnet(results_i.results(alpha_idx), results_i.scores_pos, results_i.resids', plot_options, lambda_idx);

end

end

