function [ h ] = plot_subject_edge_residuals_glmnet( result, x, y, options, idx, is_cv )

% Plots the results of @analyze_subject_edge_residuals_glmnet for a
% particular alpha and lambda. Produces a scatterplot (predicted versus
% actual for a regression model) or an ROC curve (for a classification 
% result).
%
% PARAMETERS:
% 
% result        A glmnet result;  one element of the results of 
%               @analyze_subject_edge_residuals_glmnet (corresponding to a
%               particular alpha value)
% x             The actual values, or classes
% y             The predictor values
% options       Plot options; see also @plots_glmfit
%
%       plot_scatter        Whether to plot a scatterplot (continuous
%                           only); default is true
%       plot_roc            Whether to plot an ROC curve (classify only); 
%                           default is true
%       plot_error          Whether to plot the CV RMS error over lambas;
%                           default is true
%       plot_betas          Whether to plot betas versus lambda; default is 
%                           true
%       plot_betas_xvar     What to plot on the x-axis; see @glmnetPlot;
%                           default is 'dev'
%
% lambda        [Optional] The lambda at which to predict; default is
%               the optimal lambda_1se
%
% is_cv         This is a cross-validation result (default)
%
% RETURNS:
%
% h             Handle(s) to the figure
%
% AUTHOR: Andrew Reid, MNI, 2011

% Get class of result
glmnet_object = result.glmnet_object;
class = glmnet_object.class;

if nargin < 4
   options = plot_subject_edge_residuals_glmnet_options; 
end

if nargin < 5
    lambda = result.lambda_1se;
    idx=find(glmnet_object.lambda==lambda);
    if numel(idx)==0
      error(['Lambda ', num2str(lambda), ' not found in list..']);
    end
end

if nargin < 6
    is_cv = true;
end

if strcmp(class, 'elnet')
   % Continuous regression
   predict=glmnetPredict(glmnet_object, 'response', y);
   j = 1;
   if options.plot_scatter
       options.xlim = [min(0,min(x)) max(x)];
       options.ylim = [min(0,min(x)) max(x)];
       h(j) = plots_glmfit(x,predict,idx,options);
       j = j + 1;
   end
   
   if options.plot_error && is_cv
       h(j) = figure;
       cvglmnetPlot(result);
       title(['CV Error Plot: ', options.title]);
       j = j + 1;
   end
   
   if options.plot_betas
       h(j) = figure;
       glmnetPlot(glmnet_object, options.plot_betas_xvar);
       title(['Beta Plot: ', options.title]);
   end
   
else
   % Classification 
    
    
end