function [ h ] = plot_sparsity_v_pearson( roi_data, thresholds, groups, group_names, varargin )
%PLOT_SPARSITY_V_PEARSON Plot sparsity vs. pearson coefficient thresholds
%  

do_grp = exist('groups', 'var') && ~isempty(groups);
   
if nargin < 5
   
    varargin = [{'Color'},{'r'},{'LineStyle'},{'-'}];
   
else
    %varargin = [varargin];
    
end

figure;
set(gcf,'Color','w');

if ~do_grp
    costs = zeros( length(thresholds), 1 );

    C = get_correlation_matrix2(roi_data, 1, false);

    for i = 1 : length(thresholds)
        t = thresholds(i);
        c = C.*(C>t);

        costs(i) = 1 - get_sparsity(c); 

    end

    line( thresholds, costs, varargin{:} );

else
    
    colours = [{'r'},{'g'},{'b'},{'c'},{'k'}];
    
    for g = 1 : length(group_names)
    
        group = group_names(g);
        C = get_correlation_matrix2(roi_data(strcmp(groups,group),:), 1, false);
        costs = zeros( length(thresholds), 1 );

        for i = 1 : length(thresholds)
            t = thresholds(i);
            c = C.*(C>t);
            costs(i) = 1 - get_sparsity(c); 
        end

        varargin = [{'Color'},colours(g),{'LineStyle'},{'-'}];
        line( thresholds, costs, varargin{:} );
        hold on;
    
    end
    
    legend(group_names);
    hold off;
    
end

xlabel('Pearson coefficient');
%ylabel('Cost (1-sparsity)');
ylabel('Sparsity');

end

