function [ params ] = plot_matrices_params ( matrix_list, titles, set_limits, limits )

% Generates default parameters for plot_matrices

N = size(matrix_list,1);

for i = 1 : N
   
    params(i).matrix = squeeze(matrix_list(i,:,:));
    if exist('titles','var'), params(i).title = char(titles(i)); end
    params(i).color_map = 'jet';
    if ~exist ('set_limits', 'var') || set_limits
        if exist('limits','var')
            if size(limits,1) == 1
                params(i).limits=limits;
            else
                params(i).limits=limits(i,:);
            end
        else
            if min(params(i).matrix) < 0
                params(i).limits=[-1 1];
                params(i).color_map = 'hot_cold';
            else
                params(i).limits=[0 1];
            end
        end
    end
    params(i).show_cbar=false;
end