function [ h ] = plot_matrices( matrices, n, m, options )
%PLOT_MATRICES Plots a set of matrices as a subplot of size n, m
%   
% PARAMETERS
%
% matrices          An array of structs, each containing:
%
%                   matrix - the matrix to plot
%                   color_map - the colour map (default = 'jet')
%                   limits - the colour map limits (default = matrix range)
%                   title - the title for the subplot
% m, n              Number of rows and columns, respectively
% plot_title        Title for the plot (optional; can be empty)
% show_cbar         Whether to show a colour bar (optional; false by
%                   default). Note this uses the last plot to determine the
%                   colour bar and scale.
%

if exist('options', 'var')
    show_cbar = options.show_cbar; 
    plot_title = options.plot_title;
    plot_size = options.plot_size;
end

% If n and m are not defined, calculate 2 x N
N = length(matrices);
if nargin < 2
   n = 2;
   m = int32(ceil(N / 2));
end

h=figure;
set(gcf,'Color','w');
if exist('plot_size','var')
   p = get(gcf,'Position');
   p(1)=100;
   p(2)=100;
   p(3)=plot_size(1);
   p(4)=plot_size(2);
   set(gcf,'Position',p) 
end

if exist('plot_title', 'var') && ~isempty(plot_title)
    [ax,hh] = suplabel(plot_title);
    
    set(hh,'FontSize',15);
    set(hh,'FontWeight','bold');
end

for i = 1 : N
   
    matrx = matrices(i);
    g = subplot(n,m,i);
    clear opt; opt.color_map =  'jet';
    if isfield(matrx,'color_map'),  opt.color_map = matrx.color_map; end
    if isfield(matrx,'limits'),  opt.limits = matrx.limits; end
    opt.flag_bar=false;
    if isfield(matrx,'show_cbar'),  opt.flag_bar = matrx.show_cbar; end
    
    niak_visu_matrix(matrx.matrix,opt);
    set(gca,'xtick',[])
    set(gca,'ytick',[])
    
    if opt.flag_bar, cbfreeze; end
    
    if isfield(matrx,'title')
        hh = title(matrx.title);
        set (hh, 'FontSize', 14);
        set (hh, 'FontWeight', 'bold');
    end
    
    % Enlarge
    p = get(g,'position');
    p(1) = p(1) - 0.05;   % Shift left 10% of screen
    p(2) = p(2) - 0.05;   % Shift down 10% of screen
    p(3) = p(3)*1.10; % Add 30 percent to width
    p(4) = p(4)*1.10; % Add 30 percent to height
    set(g, 'position', p);
    
    freezeColors;
   
end

if exist('show_cbar', 'var') && show_cbar
    cb=colorbar('location','South');
    set(cb,'Position',[0.35 0.085 0.3 0.03]);
    set(cb,'XAxisLocation','bottom');
    if isfield(options, 'plot_title')
        hh = title(cb,options.plot_title);
        set (hh, 'FontSize', 14);
        set (hh, 'FontWeight', 'bold');
    end
end

end

