function [ params ] = plot_horizontal_sorted_params ()

% Default parameters for plot_horizontal_sorted
%
% params        A struct with the following fields:
% y_labels      Labels for y axis - N x 1 cell vector; use []
%               for none
% sort_order    order of sort; one of 'ascend' (default) or 'descend'
% plot_title    Title for plot; [] for none
% limits        Data limits of plot (default is data range)
% plot_size     Window size
% max_bars      Maximum number of bars; default (-1) is everything
% sort_group    The column to sort by
% legend_labels The labels to show in the legend; empty (default) indicates
%               no legend
% plot_type     One of 'grouped' or 'stacked' 
%

params.y_labels = [];
params.sort_order = 'ascend';
params.plot_title = [];
params.limits = [];
params.plot_size = [900, 800];
params.max_bars = -1;
params.sort_group = 1;
params.legend_labels = [];
