function [ h ] = plot_cvglmnet_confusion( cv_results, groups, group_labels, alpha_idx, alphas, fig_title, lambda_idx, show_lambda, show_alpha )
%PLOT_CVGLMNET_CONFUSION Plots a confusion matrix for a cvglmnet_multiclass2
%                        result.
%   
% cv_results        Set of results (one per alpha value) from 
%                   cvglmnet_multiclass2
% groups            The groups to plot, as integer values
% alpha_idx         Indices for alphas to plot; default is all alphas
% alphas            Corresponding alpha values
% lambda_idx        Indices for lambdas to plot; if not specified, uses
%                   the maximal sens_spec value to determine idx
% fig_title         Title of the plots
%
% AUTHOR Andrew Reid, MNI, 2012

ugrp=unique(groups);
ng=numel(ugrp);
nr=numel(cv_results);

if nargin < 4
    alpha_idx=1:nr;
end

if nargin < 6
    fig_title = '';
end

if nargin < 8
    plot_lambda = false;
end

if nargin < 9
    plot_alpha = true;
end

for a = 1 : numel(alpha_idx)
    cv_result = cv_results(a);
    if nargin < 7
       %[~,idx]=max(cv_result.sens_spec);
       idx = find(cv_result.glmnet_object.lambda==cv_result.lambda_1se);
       idx = idx(1,1);
       lambda=cv_result.lambda_1se;
    else
        idx=lambda_idx(a);
        lambda=cv_result.glmnet_object.lambda(idx);
    end

    predicted = cv_result.predmat(:,idx);
    
    % Make target and output arguments
    for i = 1 : ng
        
        targets(i,:)=(groups==i);
        outputs(i,:)=(predicted==i);

    end
    
    index=((a-1)*3)+1;
    args(index)={targets};
    args(index+1)={outputs};
    if nargin > 4
        arg_str=fig_title;
        if plot_alpha, arg_str={sprintf('%s\\alpha=%1.2f', arg_str, alphas(a) )}; end
        if plot_lambda, arg_str={sprintf('%s, \\lambda=%1.3g', arg_str, lambda )}; end
    else
        arg_str=fig_title;
        if plot_alpha, arg_str={sprintf('%s\\alpha #%i', arg_str, a )}; end
        if plot_lambda, arg_str={sprintf('%s, \\lambda=%1.3g', arg_str, lambda )}; end
    end
    args(index+2)=arg_str;
end

if exist('group_labels','var')
   args(length(args)+1)={'labels'};
   args(length(args)+1)={group_labels};
end
h = figure;
plotconfusion2( args{:} );    

end

