function [ h ] = plot_ci_filled( x, y, upper, lower, colours, lighten )
%PLOT_CI_FILLED Plot a line with a filled confidence interval 
%   

if nargin < 6
   lighten = 0.8; 
end

if ~ismatrix(x)
    N_lines = 1;
else
    N_lines = size(x,2);
end

% Plot bounds
for i = 1 : N_lines
    colour = colours(i,:);
    fclr = lighten_colour(colour,lighten);
    xx = x(:,i);
    uu = upper(:,i);
    ll = lower(:,i);
    hh = fill([xx;xx(end:-1:1)],[uu;ll(end:-1:1)],fclr);
    set(hh,'EdgeColor','none');
    alpha(hh,0.5);
    hold on;
end

% Plot lines
for i = 1 : N_lines
    colour = colours(i,:);
    xx = x(:,i);
    yy = y(:,i);
    h = plot(xx,yy);
    set(h,'Color',colour);
    set(h,'LineWidth',2);
    hold on;
end

 hold off;

end

