function [ h ] = plot_as_surf (x, y, z, n, smooth_n, contour_int)

% Plots irregularly spaced x, y, and z as an interploted 2D image
%
% n                 - Number of points to interpolate
% smooth_n          - [Optional] Size of smoothing kernel
% contour_int       - [Optional] Interval for plotting contour lines
%
%


xlin = linspace(min(x),max(x),n);
ylin = linspace(min(y),max(y),n);

[X,Y] = meshgrid(xlin,ylin);

f = TriScatteredInterp(x,y,z,'linear');
Z = f(X,Y);

if exist('sm_n','var') && ~isempty(smooth_n);
   A = zeros(smooth_n+2);
   A(2:end-1,2:end-1)=1/smooth_n^2;
   Z2 = conv2(Z,A,'valid');
   d = length(Z) - length(Z2);
   d2 = floor(d/2);
   d = d - d2;
   Z(d2+1:end-d,d2+1:end-d)=Z2;
end

%h = figure; contourf(X,Y,Z);
h = figure; 
hh = surf(X,Y,Z,'EdgeColor','none','FaceColor','interp','FaceLighting','phong');
% set(hh,'EdgeColor','none');
% set(hh,'FaceColor','interp');
% set(hh,'EdgeLighting','phong');
%set(gca,'cameraposition',[0 0 180]);
view(0,90);
%camup(gca, [0 1 0]);

if exist('contour_int','var') && ~isempty(contour_int);
   rangeZ = max(z)-min(z);
   if rangeZ > contour_int
      rangeZ = min(z):contour_int:max(z);
      hold on;
      contour3(X,Y,Z,rangeZ,'k')
   end
end
