function [normalized] = normalize_data2(Y, norm_min, norm_max, range_min, range_max)

% Normalizes Y to the range [norm_min norm_max], by subtracting range_min and 
% dividing by range_max - range_min. Values outside this range will be 
% clamped to the nearest extreme. If range_min and range_max are not
% defined, the data range will be used
% Parameters:
% 
%     Y             A N x M matrix of data, where N is the number of subjects
%                   (independent data sources) and M is the number of data
%                   points per subject.
%
%     norm_min,norm_max       [optional] Minimum and maximum of the
%                               resulting distribution
%
%     range_min,range_max       [optional] Minimum and maximum defining the range; 
%                               values beyond this will be clamped
% 
% Returns:
%
%     The normalized data 
%
% AUTHOR Andrew Reid, MNI, 2011

if nargin < 2
    norm_min = 0;
    norm_max = 1;
end

if nargin < 4
    Y2=Y.*double(Y~=Inf);        % Ignore infinite values
    range_min = min(Y2(:));
    range_max = max(Y2(:));
end

normalized = Y;
normalized(normalized<range_min) = range_min;
normalized(normalized>range_max) = range_max;

normalized = normalized - range_min;
normalized = normalized./(range_max-range_min);

normalized = normalized * (norm_max - norm_min);
normalized = normalized + norm_min;

return;