function [normalized] = normalize_data(Y, pooled)

% Normalizes Y by subtracting the min and dividing by the range. Note;
% elements with value "Inf" will not be used to determine the range.
% 
% Parameters:
% 
%     Y             A N x M matrix of data, where N is the number of subjects
%                   (independent data sources) and M is the number of data
%                   points per subject.
%
%     pooled        If true, uses the pooled min, max;
%                   otherwise uses M-wise values. Default = false.
% 
% Returns:
%
%     The normalized data 

if nargin < 2
   pooled = false; 
end

Y2=Y.*double(Y~=Inf);        % Ignore infinite values

if pooled == true
   p_min = min(Y2(:)); 
   p_max = max(Y2(:));
   normalized = Y - p_min;
   normalized = normalized./(p_max-p_min);
   return;
end

l_min = min(Y2);
l_max = max(Y2);

normalized = bsxfun(@minus, Y, l_min);
normalized = bsxfun(@rdivide, normalized, l_max-l_min);
   