function [ S, T ] = neuro_decay_spike ( w, tau, alpha, N, delta )

if ~exist('delta','var')
   delta = 0.001; 
end
if ~exist('N','var')
   N = tau / delta * 2; 
end

t_start = -tau;
t_stop = t_start + (delta * (N - 1));
S1 = zeros(N,1);
S2 = zeros(N,1);
T = zeros(N,1);
i = 1;
for t = t_start : delta : t_stop;
   S1(i) = tanh( t );
   S2(i) = exp( -alpha * t );
   T(i) = t - t_start;
   i = i + 1;
end

S1 = normalize_data(S1, true);
S2 = normalize_data(S2, true);
S = S1.*S2;
S = normalize_data(S, true);
S = S * w;
