% modularity_optimizer: Runs the Java-based ModularityOptimizer.jar on a
% given adjacency matrix.
%
% INPUT:
% C                         The adjacency matrix
% modularity_function       Modularity function (1 = standard; 2 = alternative)
% resolution_parameter      Value of the resolution parameter
% optimization_algorithm	Algorithm for modularity optimization:
%                                  1 = original Louvain algorithm
%                                  2 = Louvain algorithm with multilevel refinement
%                                  3 = SLM algorithm
% n_random_starts           Number of random starts
% n_iterations              Number of iterations per random start
%
%%%

function [ clusters ] = modularity_optimizer ( C, modularity_function, resolution_parameter, ...
                                               optimization_algorithm, n_random_starts, n_iterations )
    
    % Defaults
    if (nargin < 2)
        modularity_function = 1;
    end
    if (nargin < 3)
        resolution_parameter = 1;
    end
    if (nargin < 4)
        optimization_algorithm = 1;
    end
    if (nargin < 5)
        n_random_starts = 10;
    end
    if (nargin < 6)
        n_iterations = 10;
    end
                                           
    % Files
    cp = '/Users/areid/Documents/java/clustering/';
    input_file = [tempname, '.in'];
    output_file = [tempname, '.out'];
    cmd = sprintf('java -cp %s -jar %sModularityOptimizer.jar %s %s %i %f %i %i %i 0 0', ...
                                    cp, cp, input_file, output_file, ...
                                    modularity_function, resolution_parameter, ...
                                    optimization_algorithm, n_random_starts, n_iterations);
                             
    % Write C to temp file
    N_vert = size(C,1);
    fid = fopen(input_file, 'w');
    for i = 1 : N_vert
        for j = i+1 : N_vert
            if C(i,j)>0
                fprintf(fid,'%i\t%i\n',i,j);
            end
        end
    end
    fclose(fid);
    
    % Call Java jar                           
    system(cmd,'-echo');    
    
    % Read output file
    fid = fopen(output_file,'r');
    clusters = fscanf(fid,'%i');
    fclose(fid);
                                           
end