%% Wilson-Cowan Simulation Test 1

% Single unit model

vertex = wilson_cowan_vertex;
vertex.tau_e = 10;
vertex.tau_i = 100;
vertex.p_ee = 5;
vertex.p_ii = 1;
vertex.p_ei = 10;
vertex.p_ie = 6;
vertex.theta_e = 1;
vertex.theta_i = 2;
vertex.a_e = 1.2; 
vertex.a_i = 2;
vertex.function = 'logistic';
vertex.external_weight = 1;
vertex.epsilon = 0.05;

params = wilson_cowan_model_params;
% Pulse train input
P = generate_pulse_train( 2000, 8000, 1, 1, 10000 );
%P = zeros(10000);
params.input_signal = P;

model = wilson_cowan_model(params);
model = wilson_cowan_add_vertex( model, vertex );

% Run simulation

options = wilson_cowan_sim_options;
options.t_stop = 10000;

results = wilson_cowan_sim ( model, options );

% Plot result
figure, plot(results.t, [P results.E results.I]);
legend([{'Ext'},{'E'},{'I'}]);


%% Wilson-Cowan Simulation Test 2

% Two unit model

vertex = wilson_cowan_vertex;
vertex.tau_e = 10;
vertex.tau_i = 100;
vertex.p_ee = 5;
vertex.p_ii = 1;
vertex.p_ei = 10;
vertex.p_ie = 6;
vertex.theta_e = 1;
vertex.theta_i = 2;
vertex.a_e = 1.2;
vertex.a_i = 2;
vertex.function = 'logistic';
vertex.external_weight = 1;
vertex.epsilon = 0.02;

params = wilson_cowan_model_params;
% Pulse train input
P = generate_pulse_train( 2000, 2000, 1, 1, 10000 );
params.input_signal = P;

model = wilson_cowan_model(params);
model = wilson_cowan_add_vertex( model, vertex );
vertex.external_weight = 0;
model = wilson_cowan_add_vertex( model, vertex );
edge = wilson_cowan_edge(1,2);
edge.weight = 0.8;
edge.delay = 100;
model = wilson_cowan_add_edge( model, edge );

% Run simulation
options = wilson_cowan_sim_options;
options.t_stop = 10000;

[results, AA] = wilson_cowan_sim ( model, options );

% Plot result
for i = 1 : 2
    figure, plot(results.t, [P results.E(:,i) results.I(:,i)] );
    legend([{'Ext'},{'E'},{'I'}]);
    title (sprintf('Vertex %i', i));
end


%% Wilson-Cowan Simulation Test 3

% Three unit model - sequential

vertex = wilson_cowan_vertex;
vertex.tau_e = 10;
vertex.tau_i = 100;
vertex.p_ee = 5;
vertex.p_ii = 1;
vertex.p_ei = 10;
vertex.p_ie = 6;
vertex.theta_e = 1;
vertex.theta_i = 2;
vertex.a_e = 1.2;
vertex.a_i = 2;
vertex.function = 'logistic';
vertex.external_weight = 1;
vertex.epsilon = 0.02;

params = wilson_cowan_model_params;
% Pulse train input
%P = generate_pulse_train( 2000, 2000, 1, 1, 10000 );
P=ones(10000,1);
params.input_signal = P;

model = wilson_cowan_model(params);

% Vertex 1
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 2
vertex.external_weight = 0;
model = wilson_cowan_add_vertex( model, vertex );
edge = wilson_cowan_edge(1,2);
edge.weight = 0.8;
edge.delay = 100;
model = wilson_cowan_add_edge( model, edge );

% Vertex 3
model = wilson_cowan_add_vertex( model, vertex );
edge = wilson_cowan_edge(2,3);
edge.weight = 0.8;
edge.delay = 100;
model = wilson_cowan_add_edge( model, edge );

% Run simulation

options = wilson_cowan_sim_options;
options.t_stop = 10000;

[results] = wilson_cowan_sim ( model, options );

% Plot result
figure
for i = 1 : 3
    subplot(3,1,i), plot(results.t, [P results.E(:,i) results.I(:,i)] );
    legend([{'Ext'},{'E'},{'I'}]);
    title (sprintf('Vertex %i', i));
end

% Plot superimposed
figure, plot(results.t, results.E);
legend([{'V1'},{'V2'},{'V3'}]);


%% Wilson-Cowan Simulation Test 4

% Three unit model - common afferent

vertex = wilson_cowan_vertex;
vertex.tau_e = 10;
vertex.tau_i = 100;
vertex.p_ee = 5;
vertex.p_ii = 1;
vertex.p_ei = 10;
vertex.p_ie = 6;
vertex.theta_e = 1;
vertex.theta_i = 2;
vertex.a_e = 1.2;
vertex.a_i = 2;
vertex.function = 'logistic';
vertex.external_weight = 1;
vertex.epsilon = 0.02;

params = wilson_cowan_model_params;
% Pulse train input
%P = generate_pulse_train( 2000, 2000, 1, 1, 10000 );
P = ones(10000,1);
params.input_signal = P;

model = wilson_cowan_model(params);

% Vertex 1 (afferent 1)
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 2 (afferent 2)
vertex.tau_e = 8;
vertex.tau_i = 110;
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 3 (target)
vertex.tau_e = 10;
vertex.tau_i = 100;
vertex.external_weight = 0;
model = wilson_cowan_add_vertex( model, vertex );
edge = wilson_cowan_edge(1,3);
edge.weight = 0.2;
edge.delay = 100;
model = wilson_cowan_add_edge( model, edge );
edge = wilson_cowan_edge(2,3);
edge.weight = 0.8;
edge.delay = 200;
model = wilson_cowan_add_edge( model, edge );

% Run simulation
options = wilson_cowan_sim_options;
options.t_stop = 10000;

[results, AA] = wilson_cowan_sim ( model, options );

% Plot result
figure
for i = 1 : 3
    subplot(3,1,i), plot(results.t, [P results.E(:,i) results.I(:,i)] );
    legend([{'Ext'},{'E'},{'I'}]);
    title (sprintf('Vertex %i', i));
end

% Plot superimposed
figure, plot(results.t, results.E);
legend([{'V1'},{'V2'},{'V3'}]);


%% Wilson-Cowan Simulation Test 5

% Three unit model - common afferent, different external inputs

vertex = wilson_cowan_vertex;
vertex.tau_e = 10;
vertex.tau_i = 100;
vertex.p_ee = 5;
vertex.p_ii = 1;
vertex.p_ei = 10;
vertex.p_ie = 6;
vertex.theta_e = 1;
vertex.theta_i = 2;
vertex.a_e = 1.2;
vertex.a_i = 2;
vertex.function = 'logistic';
vertex.epsilon = 0.02;

params = wilson_cowan_model_params;
% Pulse train input
P = zeros(10000,2);
P(:,1) = generate_pulse_train( 2000, 1500, 1, 1, 10000 );
P(:,2) = generate_pulse_train( 2000, 1500, 1, 1, 10000, 1750 );
%P = ones(10000,1);
params.input_signal = P;

model = wilson_cowan_model(params);

% Vertex 1 (afferent 1)
vertex.external_weight = [1 0];
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 2 (afferent 2)
vertex.tau_e = 8;
vertex.tau_i = 110;
vertex.external_weight = [0 1];
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 3 (target)
vertex.tau_e = 10;
vertex.tau_i = 100;
vertex.external_weight = [0 0];
model = wilson_cowan_add_vertex( model, vertex );
edge = wilson_cowan_edge(1,3);
edge.weight = 0.5;
edge.delay = 100;
model = wilson_cowan_add_edge( model, edge );
edge = wilson_cowan_edge(2,3);
edge.weight = 0.5;
edge.delay = 200;
model = wilson_cowan_add_edge( model, edge );

% Run simulation
options = wilson_cowan_sim_options;
options.t_stop = 10000;

[results, AA] = wilson_cowan_sim ( model, options );

% Plot result
figure
for i = 1 : 3
    subplot(3,1,i), plot(results.t, [P results.E(:,i) results.I(:,i)] );
    legend([{'Ext'},{'E'},{'I'}]);
    title (sprintf('Vertex %i', i));
end

% Plot superimposed
figure, plot(results.t, results.E);
legend([{'V1'},{'V2'},{'V3'}]);


%% Wilson-Cowan Simulation Test 6

% Three unit model - common efferent, different weights

vertex = wilson_cowan_vertex;
vertex.tau_e = 10;
vertex.tau_i = 100;
vertex.p_ee = 5;
vertex.p_ii = 1;
vertex.p_ei = 10;
vertex.p_ie = 6;
vertex.theta_e = 1;
vertex.theta_i = 2;
vertex.a_e = 1.2;
vertex.a_i = 2;
vertex.function = 'logistic';
vertex.epsilon = 0.02;

params = wilson_cowan_model_params;
% Pulse train input
P = zeros(10000,1);
%P(:,1) = generate_pulse_train( 2000, 1500, 1, 1, 10000 );
%P(:,2) = generate_pulse_train( 2000, 1500, 1, 1, 10000, 1750 );
%P = ones(10000,1);
params.input_signal = P;

model = wilson_cowan_model(params);

% Vertex 1 (afferent 1)
vertex.external_weight = 1;
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 2 (afferent 2)
vertex.tau_e = 8;
vertex.tau_i = 110;
vertex.external_weight = 0;
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 3 (target)
vertex.tau_e = 10;
vertex.tau_i = 100;
vertex.external_weight = 0;
model = wilson_cowan_add_vertex( model, vertex );
edge = wilson_cowan_edge(1,2);
edge.weight = 0.5;
edge.delay = 100;
model = wilson_cowan_add_edge( model, edge );
edge = wilson_cowan_edge(1,3);
edge.weight = 0.5;
edge.delay = 100;
model = wilson_cowan_add_edge( model, edge );

% Run simulation
options = wilson_cowan_sim_options;
options.t_stop = 10000;

[results, AA] = wilson_cowan_sim ( model, options );

% Plot result
figure
for i = 1 : 3
    subplot(3,1,i), plot(results.t, [P results.E(:,i) results.I(:,i)] );
    legend([{'Ext'},{'E'},{'I'}]);
    title (sprintf('Vertex %i', i));
end

% Plot superimposed
figure, plot(results.t, results.E);
legend([{'V1'},{'V2'},{'V3'}]);


%% Growth Model Test 1

% Generate results above, then run this

% Initial sizes set to 1.0

params = activity_growth_params;
params.morph_max = 0.35;
params.morph_min = 0.35;

% params.alpha = 0.0001;
% params.beta = 1;
% params.morph_std = 3;
% params.activ_mean = 0.2;
% params.activ_std = 0.05;

morph_init = repmat(params.morph_mean, size(results.E,2),1);

N_t = length(results.t);
morph = [];
ts = [];
dt = results.t(end) / N_t;
nitr = 3;

for i = 1 : nitr
    morph_results = activity_growth_sim ( morph_init, results.t, results.E, params );
    morph2 = morph_results.morph;
    if isempty(morph)
       morph = morph2; 
       ts = results.t;
    else
       morph = [morph; morph2];
       t0 = ts(end);
       ts = [ts; (t0+dt:dt:t0+N_t*dt)'];
    end
    morph_init = morph(end,:);
    
end

figure,plot(ts, morph);
ylim([2 6]);
% ylim([params.morph_mean - 2 * params.morph_std ...
%       params.morph_mean + 2 * params.morph_std]);
names = cell(3,1);
for i = 1 : size(morph_results.morph,2)
   names(i) = {sprintf('V%i',i)}; 
end
legend(names);


%% Activity & Growth Test 1

% Generate N simulations, with activity + growth
% Vary connection strengths from 0.1 to 0.9
% Evaluate morph correlations and connection strengths

lib_dir = 'C:\Users\Andrew\Documents\MATLAB\lib_areid';

%% 1. Simulate from Wilson-Cowan models

%% 1.a.a. Common afferent

N_samp = 10;
T = 10000;
weights = zeros(6,2);
weights(:,1) = 0.0 : 0.2 : 1.0;
weights(:,2) = 1 - weights(:,1);
N_w = length(weights);
P = zeros(T,2);

options = wilson_cowan_sim_options;
options.t_stop = T;

delays = 1000:250:2500;
durations = 750:250:2500;
offsets = 0:500:2000;

inputs = zeros(T,N_samp,2);

clear results;
clear models;

tic;
for i = 1 : N_samp
    j = 1;
    fprintf('\nStarting itr %i/%i', i, N_samp);
    % Randomized pulse sequences
    P(:,1) = generate_pulse_train( delays(ceil(rand*length(delays))), ...
                                   durations(ceil(rand*length(durations))), ...
                                   1, 1, T, ...
                                   offsets(ceil(rand*length(offsets))));
    P(:,2) = generate_pulse_train( delays(ceil(rand*length(delays))), ...
                                   durations(ceil(rand*length(durations))), ...
                                   1, 1, T, ...
                                   offsets(ceil(rand*length(offsets))));
    inputs(:,i,:) = P;
    for k = 1 : size(weights,1)
        w = weights(k,1);
        edge = wilson_cowan_edge(1,3);
        edge.weight = w;
        edge.delay = 50;
        edges = struct(edge);
        w = weights(k,2);
        edge = wilson_cowan_edge(2,3);
        edge.weight = w;
        edge.delay = 50;
        edges(2) = edge;
        
        [r,m] = wilson_cowan_sim_4(edges, P, options);
        results(i,j) = r;
        models(i,j) = m;
        
        j = j + 1;
        fprintf('\nDone weight %1.3f (%1.2f s)', w, toc);
    end
    fprintf('\nDone itr %i/%i (%1.2f s)', i, N_samp, toc);
end

w_str1 = '(1,3)';
w_str2 = '(2,3)';

%% 1.a.b. Common afferent, parallel (local)

clear params;
params.n_trials = 30;
params.weights = zeros(6,2);
params.weights(:,1) = 0.0 : 0.2 : 1.0;
params.weights(:,2) = 1 - params.weights(:,1);
N_w = size(params.weights,1);

params.sim_options = wilson_cowan_sim_options;
params.sim_options.t_stop = 10000;

params.delays = 1000:250:2500;
params.durations = 750:250:2500;
params.offsets = 0:500:2000;
  
% Local host
n_proc = 7;     % Set number of processors to use
params.output_dir = 'C:\Users\Andrew\Documents\MATLAB\modelling\results_parallel';
 job = batch('wilson_cowan_sim_4_parallel', 2, {params}, ...
   'matlabpool', n_proc);

wait(job);                      % Wait for the job to finish
outputs = fetchOutputs(job);    % Fetch results

N_samp = params.n_trials;
weights = params.weights;
T = params.sim_options.t_stop;
M = outputs{1};
clear results;
%results = cell(N_samp,N_w);
for i = 1 : N_samp
    for j = 1 : N_w
       results(i,j) = M{i}{j}; 
    end 
end
M = outputs{2};
%models = cell(N_samp,N_w);
clear models;
for i = 1 : N_samp
    for j = 1 : N_w
       models(i,j) = M{i}{j}; 
    end 
end
      
w_str1 = '(1,3)';
w_str2 = '(2,3)';

%% 1.a.c. Common afferent, parallel (remote - Guillimin)

params.n_trials = 30;
params.weights = zeros(6,2);
params.weights(:,1) = 0.0 : 0.2 : 1.0;
params.weights(:,2) = 1 - params.weights(:,1);
N_w = size(params.weights,1);

params.sim_options = wilson_cowan_sim_options;
params.sim_options.t_stop = 10000;

params.delays = 1000:250:2500;
params.durations = 750:250:2500;
params.offsets = 0:500:2000;

% Paths to required m files
lib_paths = {fullfile(lib_dir, 'models'), ...
             fullfile(lib_dir, 'models', 'wilson_cowan')};
         
% Guillimin
% Note: you must set the # nodes, processors per node, and wall time using the 
%       moab.m function in the same directory as this script. Reserve
%       n_trials+1 processors.
n_proc = params.n_trials / 12;  % Set number of processors to use
ppn = 12;                       % Set processors per node (12 max)
wall_time = '03:00:00';         % Set wall time
set_moab_file(fullfile(lib_dir, 'models', 'wilson_cowan'), n_proc, ppn, wall_time);
params.output_dir = '/home/areid';
myCluster = parcluster('Guillimin');
job = batch(myCluster,'wilson_cowan_sim_4_parallel', 2, {params}, ...
          'matlabpool', n_proc, 'AdditionalPaths', lib_paths);
wait(job);                     % Wait for the job to finish
outputs = fetchOutputs(job);   % Fetch results
results = outputs(1);
models = outputs(2);

w_str1 = '(1,3)';
w_str2 = '(2,3)';

%% 1.b. Sequential

N_samp = 20;
T = 10000;
weights = zeros(6,2);
weights(:,2) = 0.0 : 0.25 : 1.25;
weights(:,1) = ones(6,1)+0.2;
N_w = length(weights);
P = zeros(T,1);
options = wilson_cowan_sim_options;
options.t_stop = T;

delays = 1000:250:2500;
durations = 750:250:2500;
offsets = 0:500:2000;

inputs = zeros(T,N_samp);

clear results;

tic;
for i = 1 : N_samp
    j = 1;
    fprintf('\nStarting itr %i/%i', i, N_samp);
    % Randomized pulse sequences
    P = generate_pulse_train( delays(ceil(rand*length(delays))), ...
                                   durations(ceil(rand*length(durations))), ...
                                   1, 1, T, ...
                                   offsets(ceil(rand*length(offsets))));
    inputs(:,i) = P;
    for k = 1 : N_w
        w = weights(k,1);
        edge = wilson_cowan_edge(1,2);
        edge.weight = w;
        edge.delay = 50;
        edges = struct(edge);
        w = weights(k,2);
        edge = wilson_cowan_edge(2,3);
        edge.weight = w;
        edge.delay = 50;
        edges(2) = edge;
        
        r = wilson_cowan_sim_3(edges, P, options);
        results(i,j) = r;
        
        j = j + 1;
        fprintf('\nDone weight %1.3f (%1.2f s)', w, toc);
    end
    fprintf('\nDone itr %i/%i (%1.2f s)', i, N_samp, toc);
end

w_str1 = '(1,2)';
w_str2 = '(2,3)';

%% 1.b.b. Sequential, parallel (local)

clear params;
params.n_trials = 30;
params.weights = zeros(6,2);
params.weights(:,1) = 0.0 : 0.2 : 1.0;
params.weights(:,2) = 1 - params.weights(:,1);
N_w = size(params.weights,1);

params.sim_options = wilson_cowan_sim_options;
params.sim_options.t_stop = 10000;

params.delays = 1000:250:2500;
params.durations = 750:250:2500;
params.offsets = 0:500:2000;
  
% Local host
n_proc = 7;     % Set number of processors to use
params.output_dir = 'C:\Users\Andrew\Documents\MATLAB\modelling\results_parallel';
 job = batch('wilson_cowan_sim_4_parallel', 2, {params}, ...
   'matlabpool', n_proc);

wait(job);                      % Wait for the job to finish
outputs = fetchOutputs(job);    % Fetch results

N_samp = params.n_trials;
weights = params.weights;
T = params.sim_options.t_stop;
M = outputs{1};
clear results;
%results = cell(N_samp,N_w);
for i = 1 : N_samp
    for j = 1 : N_w
       results(i,j) = M{i}{j}; 
    end 
end
M = outputs{2};
%models = cell(N_samp,N_w);
clear models;
for i = 1 : N_samp
    for j = 1 : N_w
       models(i,j) = M{i}{j}; 
    end 
end
      
w_str1 = '(1,3)';
w_str2 = '(2,3)';

%% 1.b.c. Sequential, parallel (remote - Guillimin)

params.n_trials = 30;
params.weights = zeros(6,2);
params.weights(:,1) = 0.0 : 0.2 : 1.0;
params.weights(:,2) = 1 - params.weights(:,1);
N_w = size(params.weights,1);

params.sim_options = wilson_cowan_sim_options;
params.sim_options.t_stop = 10000;

params.delays = 1000:250:2500;
params.durations = 750:250:2500;
params.offsets = 0:500:2000;

% Paths to required m files
lib_paths = {fullfile(lib_dir, 'models'), ...
             fullfile(lib_dir, 'models', 'wilson_cowan')};
         
% Guillimin
% Note: you must set the # nodes, processors per node, and wall time using the 
%       moab.m function in the same directory as this script. Reserve
%       n_trials+1 processors.
n_proc = params.n_trials / 12;  % Set number of processors to use
ppn = 12;                       % Set processors per node (12 max)
wall_time = '03:00:00';         % Set wall time
set_moab_file(fullfile(lib_dir, 'models', 'wilson_cowan'), n_proc, ppn, wall_time);
params.output_dir = '/home/areid';
myCluster = parcluster('Guillimin');
job = batch(myCluster,'wilson_cowan_sim_4_parallel', 2, {params}, ...
          'matlabpool', n_proc, 'AdditionalPaths', lib_paths);
wait(job);                     % Wait for the job to finish
outputs = fetchOutputs(job);   % Fetch results
results = outputs(1);
models = outputs(2);

w_str1 = '(1,3)';
w_str2 = '(2,3)';

%% 1.c. Common efferent

N_samp = 20;
T = 10000;
weights = zeros(6,2);
weights(:,1) = 0.0 : 0.25 : 1.25;
weights(:,2) = 1.25 : -0.25 : 0.0;
N_w = length(weights);
P = zeros(T,1);
options = wilson_cowan_sim_options;
options.t_stop = T;

delays = 1000:250:2500;
durations = 750:250:2500;
offsets = 0:500:2000;

inputs = zeros(T,N_samp);

clear results;

tic;
for i = 1 : N_samp
    j = 1;
    fprintf('\nStarting itr %i/%i', i, N_samp);
    % Randomized pulse sequences
    P = generate_pulse_train( delays(ceil(rand*length(delays))), ...
                                   durations(ceil(rand*length(durations))), ...
                                   1, 1, T, ...
                                   offsets(ceil(rand*length(offsets))));
    inputs(:,i) = P;
    for k = 1 : N_w
        w = weights(k,1);
        edge = wilson_cowan_edge(1,2);
        edge.weight = w;
        edge.delay = 50;
        edges = struct(edge);
        w = weights(k,2);
        edge = wilson_cowan_edge(1,3);
        edge.weight = w;
        edge.delay = 50;
        edges(2) = edge;
        
        r = wilson_cowan_sim_5(edges, P, options);
        results(i,j) = r;
        
        j = j + 1;
        fprintf('\nDone weight %1.3f (%1.2f s)', w, toc);
    end
    fprintf('\nDone itr %i/%i (%1.2f s)', i, N_samp, toc);
end

w_str1 = '(1,2)';
w_str2 = '(2,3)';

%% 1.1. Plot pulse sequences

i = 1;
colours = ['b','g'];
h=figure;
set(h,'Color','w');
for b = 1 : size(inputs,3);
    P = squeeze(inputs(:,i,b));
    h=area(results(i,1).t, P);
    set(h(1),'FaceColor',colours(b));
    hold on;
end

ylim([0 1.2]);
hold off;

%% 1.2. Plot activity
I = 1; J = [1 4 6];

for ii = 1 : length(I)
    i = I(ii);
    h = figure;
    set (h, 'Color', 'w');
    for jj = 1 : length(J)
        j = J(jj);
        result = results(i,j);
        subplot(length(J),1,jj); plot(result.t, result.E);
        xlabel(sprintf('w%s= %1.2f; w%s= %1.2f', w_str1, weights(j,1), w_str2, weights(j,2)));
        ylim([0 1]);
    end
    suptitle(sprintf('Simulated activity (trial #%i)', i));
    legend([{'V1'},{'V2'},{'V3'}]);
end

%% 1.3. Integrate time series

clear results2;

for i = 1 : N_samp
    for j = 1 : N_w
        result = results(i,j);
        %[result.E_int, result.t_int] = integrate_tseries(result.t, result.E, 100);
        [result.E_int] = smooth_tseries(result.t, result.E, 50);
        results2(i,j) = result;
    end
end

results = results2;
clear results2;

%% 1.4. Plot integrated results

I = 1; J = [1];

for ii = 1 : length(I)
    i = I(ii);
    figure;
    for jj = 1 : length(J)
        j = J(jj);
        result = results(i,j);
        subplot(length(J),1,j); plot(result.t, result.E_int);
        xlabel(sprintf('w(1,3)= %1.2f; w(2,3)= %1.2f', weights(j), 1-weights(j)));
        ylim([0 1]);
    end
    title(sprintf('Smoothed activity (%i/%i)', i, N_samp));
    legend([{'V1'},{'V2'},{'V3'}]);
end

%% 1.5. Wavelet transformed

wname = 'morl';
scales = [1:50];

clear results2;

tic;
for i = 1 : N_samp
    for j = 1 : N_w
        result = results(i,j);
        % Wavelet transform across scales
        result.E_wav = cwt_tseries(result.E, scales, wname);
        % Convert to absolute power
        result.E_wav = sum(abs(result.E_wav),3);
        % Smooth activity across time
        result.E_wav = smooth_tseries(result.t, result.E_wav,100);
        result.E_wav = smooth_tseries(result.t, result.E_wav,100);
        % Apply logistic to transform to [0 1]
        result.E_wav = logistic(result.E_wav,0.05,1);
        result.E_wav = (result.E_wav - 0.5) * 2;
        results2(i,j) = result;
    fprintf('\nDone weight %1.3f (%1.2f s)', weights(j), toc);
    end
fprintf('\nDone itr %i/%i (%1.2f s)', i, N_samp, toc);
end

results = results2;
clear results2;

%% Plot wavelet transformed

I = 1; J = [1 4 6];

for ii = 1 : length(I)
    i = I(ii);
    h = figure;
    
    set(h,'Color','w');
    for jj = 1 : length(J)
        j = J(jj);
        result = results(i,j);
        subplot(length(J),1,jj); plot(result.t, result.E_wav);
        xlabel(sprintf('w%s= %1.2f; w%s= %1.2f', w_str1, weights(j,1), w_str2, weights(j,2)));
        ylim([0 1]);
    end
    
    legend([{'V1'},{'V2'},{'V3'}]);
end

suptitle(sprintf('Wavelet-transformed activity (trial #%i)', i));

%% 2. Simulate growth

%% 2.1. Set activity thresholds

% Idea is to define thresholds based on activity distribution for each
% vertex

thres_abs_min = 0.2;
thres_abs_max = 0.9;
activity_window = [0.1 0.6];
thres_dist = .5;
thres_factor = 0.7;
model = models(1,1);
N_v = length(model.vertices);
clear activity;

for i = 1 : N_samp
    for j = 1 : N_w
        model = models(i,j);
        result = results(i,j);
        clear vertices;
        for k = 1 : N_v
            E_wav = result.E_wav(:,k);
            E2 = E_wav(E_wav > activity_window(1) & E_wav < activity_window(2));
            m = mean(E2);
            m = m * thres_factor;
            s = std(E2);
            activity.thres_high = min(m + thres_dist * s, thres_abs_max);
            activity.thres_low = max(m - thres_dist * s, thres_abs_min);
            vertex = model.vertices(k);
            vertex.activity = activity;
            vertices(k) = vertex;
        end
        model.vertices = vertices;
        models(i,j) = model;
    end 
end

%% 2.2. Simulate

params = activity_growth_thres_params;
params.morph_min = 0.2;
params.morph_max = 0.9;
params.tau = 1000;
params.thres_A_low = 0.3;
params.thres_A_high = 0.5;

% params = activity_growth_gauss_params;
% params.alpha = 0.0005;
% params.beta = 1;
% params.morph_std = 3;
% params.activ_mean = 0.2;
% params.activ_std = 0.1;

morph_init = repmat(0.5, N_v, 1);
tic;

for i = 1 : N_samp
    for j = 1 : N_w
        model = models(i,j);
        result = results(i,j);
        morph_results = activity_growth_sim_thres ( morph_init, result.t, ...
                                                    result.E_wav, params, model.vertices );
        %morph_results = activity_growth_gauss_sim ( morph_init, result.t, result.E_wav, params );
        results(i,j).morph = morph_results.morph;
    end
    fprintf('\nDone itr %i/%i (%1.2f s)', i, N_samp, toc);
end

%% 2.3. Plot individual morphometry

I = 1; J = [1 4 6];

for ii = 1 : length(I)
    i = I(ii);
    h = figure;
    set(h,'Color','w');
    for jj = 1 : length(J)
        j = J(jj);
        result = results(i,j);
        subplot(length(J),1,jj); plot(result.t, result.morph);
        xlabel(sprintf('w%s= %1.2f; w%s= %1.2f', w_str1, weights(j,1), w_str2, weights(j,2)));
        ylim([0 1]);
    end
    %title(sprintf('Activity (%i/%i)', i, N_samp));
    suptitle (sprintf('Morphometry(trial# %i)', i)); 
    legend([{'V1'},{'V2'},{'V3'}]);
    %title (sprintf('Morphometry(%i,%i)', i, N_samp));
    
       
end


%% 3. Compare

% Correlation morphometry (final state)

N_rnd = 100;     % Random samples from each morphometry

morph_final = zeros(N_samp*N_rnd,N_w,3);

for i = 1 : N_samp
    for j = 1 : N_w
        result = results(i,j);
        k = 1;
        idx = randsample(T,1000);
        for r = 1 : N_rnd
            morph_final((i-1)*N_rnd+k,j,:) = result.morph(idx(r),:);
            k = k + 1;
        end
    end
end

C = zeros(N_w,3,3);
for j = 1 : N_w
    m = squeeze(morph_final(:,j,:));
    C(j,:,:) = corrcoef(m);
end

% Table
names = [{'Weight'},{'c(1,3)'},{'c(2,3)'}];
values = zeros(N_w,4);
for j = 1 : N_w
    c_j = squeeze(C(j,:,:));
    values(j,1) = weights(j,2);
    values(j,2) = c_j(1,2);
    values(j,3) = c_j(2,3);
    values(j,4) = c_j(1,3);
end

%% Plot comparison

sig = 0.45;

h=figure,p=plot(values(:,1),values(:,2:end));
set(h,'Color','w');
legend([{'V1-V2'},{'V1-V3'},{'V2-V3'}]);

set (p,'LineWidth',2);
hold on;

% p=plot([values(1,1) values(N_w,1)],[-sig -sig], 'k:');
% set (p,'LineWidth',2);
p=plot([values(1,1) values(N_w,1)],[sig sig], 'k:');
set (p,'LineWidth',2);

xlabel('Weight (V2-V3)');
ylabel('Correlation');