function [ results ] = wilson_cowan_sim_5( edges, input, options )
% Three unit model - common efferent

vertex = wilson_cowan_vertex;
vertex.tau_e = 5;
vertex.tau_i = 50;
vertex.p_ee = 5;
vertex.p_ii = 1;
vertex.p_ei = 10;
vertex.p_ie = 6;
vertex.theta_e = 1;
vertex.theta_i = 2;
vertex.a_e = 1.2;
vertex.a_i = 2;
vertex.function = 'logistic';
vertex.external_weight = 1;
vertex.epsilon = 0.02;

params = wilson_cowan_model_params;
params.input_signal = input;

model = wilson_cowan_model(params);

% Vertex 1 (first)
vertex.external_weight = 1;
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 2 (middle)
vertex.external_weight = 0;
vertex.afferent_weight = -1;
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 3 (last)
vertex.external_weight = 0;
vertex.afferent_weight = -1;
model = wilson_cowan_add_vertex( model, vertex );
edge = edges(1);
model = wilson_cowan_add_edge( model, edge );
edge = edges(2);
model = wilson_cowan_add_edge( model, edge );

% Run simulation
results = wilson_cowan_sim ( model, options );

end

