function [ results, model ] = wilson_cowan_sim_4( edges, input, options )
% Three unit model - common afferent

N_i = size(input,2);

vertex = wilson_cowan_vertex;
vertex.tau_e = 5;
vertex.tau_i = 50;
vertex.p_ee = 5;
vertex.p_ii = 1;
vertex.p_ei = 10;
vertex.p_ie = 6;
vertex.theta_e = 1;
vertex.theta_i = 2;
vertex.a_e = 1.2;
vertex.a_i = 2;
vertex.function = 'logistic';
vertex.external_weight = 1;
vertex.epsilon = 0.02;

params = wilson_cowan_model_params;
% Pulse train input
params.input_signal = input;

model = wilson_cowan_model(params);

% Vertex 1 (afferent 1)
if N_i > 1
    vw = zeros(1,N_i);
    vw(1) = 2;
    vertex.external_weight = vw;
end
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 2 (afferent 2)
if N_i > 1
    vw = zeros(1,N_i);
    vw(2) = 2;
    vertex.external_weight = vw;
end
vertex.tau_e = 5;
vertex.tau_i = 50;
vertex.theta_e = 1;
model = wilson_cowan_add_vertex( model, vertex );

% Vertex 3 (target)
% vertex.tau_e = 5;
% vertex.tau_i = 50;
% vertex.p_ee = 0;
% vertex.p_ii = 1;
% vertex.p_ei = 20;
% vertex.p_ie = 1;
vertex.external_weight = [0 0]; % zeros(1,N_i);
%vertex.theta_e=0.8;
vertex.afferent_weight = 1.5;
model = wilson_cowan_add_vertex( model, vertex );
edge = edges(1);
model = wilson_cowan_add_edge( model, edge );
edge = edges(2);
model = wilson_cowan_add_edge( model, edge );

% Run simulation
results = wilson_cowan_sim ( model, options );
results.inputs = input;

end

