function [ params ] = wilson_cowan_run_params(  )
%WILSON_COWAN_RUN_PARAMS Parameters for 
% wilson_cowan_runs.m

% Simulation options
options = wilson_cowan_sim_options;
options.t_stop = 10000; 

clear params;
params.lib_dir = '/home/typically/Documents/MATLAB/lib_areid';
params.sim_options = options;
params.iterate_on = 'trials';

% Vertex prototype
vertex = wilson_cowan_vertex;
vertex.tau_e = 5;
vertex.tau_i = 50;
vertex.p_ee = 6;
vertex.p_ii = 1;
vertex.p_ei = 10;
vertex.p_ie = 6;
vertex.theta_e = 1;
vertex.theta_i = 2;
vertex.a_e = 1.2;
vertex.a_i = 2;
vertex.function = 'logistic';
vertex.external_weight = 0;
vertex.afferent_weight = -1;
vertex.epsilon = 0.1; % 0.02;
vertex.morphology = 3;
params.vertex_prototype = vertex;

% Edge prototype
edge = wilson_cowan_edge(1,2);
edge.weight = 1;
edge.delay = 0;
params.edge_prototype = edge;

% Pulse generation parameters
%params.external_input = 'none';
params.external_input = 'pulse_train';
params.delays = 1000:250:2500;
params.durations = 750:250:2500;
params.offsets = 0:500:2000;

% Edge weight iterations
params.n_weights = 10;

% Edge delay iterations
params.n_delays = 1;

% Rewire probability iterations
params.n_probs = 1;

% Wavelet transform parameters
params.wav_name = 'morl';
params.wav_scales = 1:50;

% Wavelet coherence parameters
params.wcoh_name = 'cmor1-2';
params.wcoh_fs = 1000;
params.wcoh_dt = 0.1;
params.wcoh_t_step = 5;
params.wcoh_band = [20 200];

% Partial coherence edge triplets
% (y,x1,x2), where partial coherence is computed as y,x1 removing x2
params.pcoh_triplets = [];

% Morphology parameters
morph_params = activity_growth_gauss_params;
morph_params.fixed_distribution = false;
morph_params.activ_mean = 0.2;
morph_params.activ_std = 0.07;
morph_params.morph_mean = 3;
morph_params.morph_std = 1.5;
morph_params.alpha = 0.0001;
morph_params.beta = 1.5;
params.morph_params = morph_params;

% Trial iterations
params.n_trials = 20;

% Run ID number
params.run_id = 1;
params.description = '';

% Parallel stuff
params.paths = {};
params.output_file = '';
params.output_dir = '/home/typically/MATLAB/modelling/results_parallel';
params.clean_scratch = false;

params.log_dir = params.output_dir;
params.output_file = 'test.mat';
params.n_output_files = 1;
params.scratch_dir = fullfile(params.output_dir, 'scratch');

% Output figures
params.figures_dir = fullfile(params.output_dir, 'figures');

end

