function [ vertex ] = wilson_cowan_vertex(  )
%WILSON_COWAN_VERTEX 
%
% Generate a struct contain parameters for a single vertex in the modified 
% Wilson-Cowan model; this simulates a cortical region as a single 
% neuronal population with E and I pools.
%

vertex.label = 'V';
vertex.p_ee = 1;        % E-E weight
vertex.p_ei = 1;        % E-I weight
vertex.p_ii = 1;        % I-I weight
vertex.p_ie = 1;        % I-E weight
vertex.tau_e = 1;       % Tau (time constant) for excitatory neurons
vertex.tau_i = 1;       % Tau (time constant) for inhibitory neurons
vertex.theta_e = 1;     % Theta (threshold) for excitatory neurons
vertex.theta_i = 1;     % Theta (threshold) for inhibitory neurons
vertex.a_e = 1;         % scaling parameter for excitatory neurons
vertex.a_i = 1;         % Scaling parameter for inhibitory neurons

vertex.function = 'logistic';       % Response function; one of 'logistic',
                                    % 'tanh', 'naka-rushdon'
vertex.function_params = [];        % Parameters for the selected function

vertex.external_weight = 0;         % Weight for external input
vertex.afferent_weight = -1;        % If positive, normalizes the sum of 
                                    % afferent weights to this value; if
                                    % zero, sets afferent input to zero;
                                    % otherwise, uses raw weights.

vertex.epsilon = 0;                 % Epsilon (sqrt factor) for Gaussian white noise;
                                    % of the form Noise = sqrt(2 * epsilon) *
                                    % wgn(N_t, 1, 1)

vertex.morphology = 1;              % Morphology (e.g., size) of this vertex
vertex.activity = [];               % Variable for vertex activity 
                                    
end

