function [ results, models ] = wilson_cowan_sim_4_parallel( params )
%WILSON_COWAN_SIM_4_PARALLEL 
%
% Three unit model - common afferent; parallel implementation
%  
%  Iterations:
%   params.weights      - edge weights between V1-V3 and V2-V3
%   params.n_trials     - number of random trials to simulate
% 
%  Random pulse inputs
%   params.delays       - possible delays to choose from
%   params.offsets      - possible offsets to choose from
%   params.durations    - possible durations to choose from
%
%  Simulation options
%   params.sim_options  - see wilson_cowan_sim_options
%
%  Output options
%   params.output_dir   - directory in which to write output
%

prog_file = fullfile(params.output_dir, 'wilson_cowan_4_progress.txt');
fid=fopen(prog_file,'w');
fprintf(['Progress for parallel processing of Wilson Cowan 3-vertex' ... 
        'model - common afferent\n']);
fprintf('Trials: %i\nWeights: %i\n', params.n_trials, length(params.weights));
fclose(fid);
N_w = size(params.weights,1);
delays = params.delays;
offsets = params.offsets;
durations = params.durations;
weights = params.weights;

N_trials = params.n_trials;

options = params.sim_options;
T = options.t_stop;

clear results;
clear models;

results = cell(N_trials,1);
models = cell(N_trials,1);
parfor i = 1 : N_trials
    j = 1;
    tic;
    fid = fopen(prog_file,'a');
    fprintf(fid,'\nStarting itr %i/%i', i, N_trials);
    fclose(fid);
    % Randomized pulse sequences
    P=zeros(T,2);
    P(:,1) = generate_pulse_train( delays(ceil(rand*length(delays))), ...
                                   durations(ceil(rand*length(durations))), ...
                                   1, 1, T, ...
                                   offsets(ceil(rand*length(offsets))));
    P(:,2) = generate_pulse_train( delays(ceil(rand*length(delays))), ...
                                   durations(ceil(rand*length(durations))), ...
                                   1, 1, T, ...
                                   offsets(ceil(rand*length(offsets))));
    results_w = cell(N_w,1);
    models_w = cell(N_w,1);
    for k = 1 : N_w
        w = weights(k,1);
        edge = wilson_cowan_edge(1,3);
        edge.weight = w;
        edge.delay = 50;
        edges = struct(edge);
        w = weights(k,2);
        edge = wilson_cowan_edge(2,3);
        edge.weight = w;
        edge.delay = 50;
        edges(2) = edge;
        
        [r,m] = wilson_cowan_sim_4(edges, P, options);
        results_w(k) = {r};
        models_w(k) = {m};
        
        j = j + 1;
        fid = fopen(prog_file,'a');
        fprintf(fid,'\n(%i/%i) Done weight %1.3f (%1.2f s)', i, N_trials, w, toc);
        fclose(fid);
    end
    results(i) = {results_w};
    models(i) = {models_w};
    fid = fopen(prog_file,'a');
    fprintf(fid,'\nDone itr %i/%i (%1.2f s)', i, N_trials, toc);
    fclose(fid);
end

end

