function [ model ] = wilson_cowan_model_from_graph( G, D, params, vertex )
%WILSON_COWAB_SET_FROM_GRAPH Generates a WC model from the given graph
%   
% PARAMETERS:
%
% G         Weighted graph from which to construct the model; each i,j entry
%           corresponds to an edge from i to j, with weight G(i,j)
% D         Delays for each edge i,j. If this is empty or absent, delays
%           will be set to 0.0
% params    Parameters for the model. If missing or empty, this is
%           generated from the default from wilson_cowan_model_params.
% vertex    Prototype vertex. If missing this is generated from the default
%           from wilson_cowan_vertex.
%
%

N_vert = length(G);

if nargin < 2
   D = zeros(N_vert); 
end

if isempty(D)
   D = zeros(N_vert); 
end

if nargin < 3
   params = wilson_cowan_model_params;
end

if nargin < 4
   vertex = wilson_cowan_vertex; 
end

model = wilson_cowan_model(params);

% Add vertices
for i = 1 : N_vert
    V = vertex;
    V.label = sprintf('V%i',i);
    model = wilson_cowan_add_vertex( model, V );
end

% Add edges
for i = 1 : N_vert
   for j = 1 : N_vert 
        if G(i,j)>0
            edge = wilson_cowan_edge(i,j);
            edge.weight = G(i,j);
            edge.delay = D(i,j);
            model = wilson_cowan_add_edge( model, edge );
        end
   end
end

end

