function [ W, D ] = wilson_cowan_matrices( model )
%WILSON_COWAN_MATRICES Generates weight and delay matrices from the model
%   

N_v = length(model.vertices);

W = zeros(N_v);
D = zeros(N_v);

N_e = length(model.edges);

for i = 1 : N_e
    edge = model.edges(i);
    W(edge.from, edge.to) = edge.weight;
    D(edge.from, edge.to) = edge.delay;
end

% Zero or negative weight = infinite delay
D(W<=0)=Inf;

end

