function [ model, idx ] = wilson_cowan_add_edge( model, edge )
%WILSON_COWAN_ADD_EDGE Adds an edge to the model
%   
% Returns: the index of the new edge

if( length(model.vertices) < edge.from )
   error('Vertex does not exist: %i', edge.from);  
end
if( length(model.vertices) < edge.to)
   error('Vertex does not exist: %i', edge.to);  
end
if isempty(model.edges)
    model.edges = struct(edge);
    idx = 1;
    return
end

idx = length(model.edges) + 1;
model.edges(idx) = edge;

end

